/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class CipherOutputStream
extends FilterOutputStream {
    protected BufferedBlockCipher cipher;
    private byte[] outBuf = new byte[0];
    private boolean closed;

    public CipherOutputStream(OutputStream out, BufferedBlockCipher cipher) {
        super(out);
        this.cipher = cipher;
    }

    public void write(int b) throws IOException {
        this.ensureInit();
        int outLen = this.cipher.getUpdateOutputSize(1);
        if (outLen > this.outBuf.length) {
            this.outBuf = new byte[outLen];
        }
        if ((outLen = this.cipher.processByte((byte)b, this.outBuf, 0)) > 0) {
            this.out.write(this.outBuf, 0, outLen);
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.ensureInit();
        int outLen = this.cipher.getUpdateOutputSize(len);
        if (outLen > this.outBuf.length) {
            this.outBuf = new byte[outLen];
        }
        outLen = this.cipher.processBytes(buf, off, len, this.outBuf, 0);
        this.out.write(this.outBuf, 0, outLen);
    }

    public void finish() throws IOException {
        this.ensureInit();
        int outLen = this.cipher.getOutputSize(0);
        if (outLen > this.outBuf.length) {
            this.outBuf = new byte[outLen];
        }
        try {
            outLen = this.cipher.doFinal(this.outBuf, 0);
        }
        catch (InvalidCipherTextException icte) {
            IOException ioe = new IOException(icte.toString());
            ioe.initCause(icte);
            throw ioe;
        }
        this.out.write(this.outBuf, 0, outLen);
        this.out.flush();
    }

    private final void ensureInit() throws IOException {
        if (this.cipher == null) {
            throw new IOException("CipherOutputStream has already been closed or is not initialized!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.finish();
            }
            finally {
                this.cipher = null;
                super.close();
            }
        }
    }
}

