/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip.raes;

import de.schlichtherle.crypto.io.raes.KeyManagerRaesParameters;
import de.schlichtherle.crypto.io.raes.RaesKeyException;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.TransientIOException;
import de.schlichtherle.io.archive.zip.JarDriver;
import de.schlichtherle.io.archive.zip.JarEntry;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;

public abstract class AbstractZipRaesDriver
extends JarDriver {
    private static final long serialVersionUID = 8191673749851616843L;
    private final long authenticationTrigger;

    protected AbstractZipRaesDriver(Icon openIcon, Icon closedIcon, boolean preambled, boolean postambled, int level, long authenticationTrigger) {
        super(openIcon, closedIcon, preambled, postambled, level);
        this.authenticationTrigger = authenticationTrigger;
    }

    public final long getAuthenticationTrigger() {
        return this.authenticationTrigger;
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        RaesReadOnlyFile rrof;
        try {
            rrof = RaesReadOnlyFile.getInstance(rof, this.getRaesParameters(archive));
        }
        catch (RaesKeyException failure) {
            throw new TransientIOException(failure);
        }
        if (rof.length() <= this.getAuthenticationTrigger()) {
            rrof.authenticate();
        }
        return super.createInputArchive(archive, rrof);
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String entryName, ArchiveEntry template) throws CharConversionException {
        JarEntry entry = (JarEntry)super.createArchiveEntry(archive, entryName, template);
        if (entry.getMethod() != 8) {
            entry.setMethod(8);
            entry.setCompressedSize(-1L);
        }
        return entry;
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream out, InputArchive source) throws IOException {
        RaesOutputStream ros;
        try {
            ros = RaesOutputStream.getInstance(out, this.getRaesParameters(archive));
        }
        catch (RaesKeyException failure) {
            throw new TransientIOException(failure);
        }
        return super.createOutputArchive(archive, ros, source);
    }

    public RaesParameters getRaesParameters(Archive archive) {
        return new KeyManagerRaesParameters(archive.getPath());
    }
}

