/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.creditcard;

import clearcommerce.ssl.JCharge;
import clearcommerce.ssl.JOrder;
import clearcommerce.ssl.JOrderItem;
import clearcommerce.ssl.JPayment;
import clearcommerce.ssl.JRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.dentaku.services.creditcard.CardProcessor;
import org.dentaku.services.creditcard.CardProcessorDAO;
import org.dentaku.services.creditcard.Contact;
import org.dentaku.services.creditcard.CreditCard;
import org.dentaku.services.creditcard.CreditCardCharge;
import org.dentaku.services.creditcard.LineItem;
import org.dentaku.services.creditcard.SalesReceipt;

public class JLinkCardProcessor
implements CardProcessor {
    private HashMap config = new HashMap(5);
    private CardProcessorDAO dao;

    public Object getConfigurationValue(String key) {
        return this.config.get(key);
    }

    public void setConfigurationValue(String key, Object value) {
        this.config.put(key, value);
    }

    public CardProcessorDAO getDao() {
        return this.dao;
    }

    public CreditCardCharge preAuthPayment(SalesReceipt receipt, CreditCard card, Contact billingContact) {
        JOrder order = this.getOrder(receipt, billingContact);
        JRequest request = this.getPreauthRequest(card, billingContact);
        request.setChargeTotal(order.getSubtotal());
        JPayment payment = new JPayment();
        JCharge charge = payment.processTransaction(request, order);
        CreditCardCharge ccc = this.dao.getNewCreditCardCharge(charge, order, request);
        return ccc;
    }

    public CreditCardCharge postAuthPayment(CreditCardCharge ccCharge) {
        JCharge charge = ccCharge.getCharge();
        JOrder order = ccCharge.getOrder();
        JRequest request = ccCharge.getRequest();
        request.setChargeType(2);
        order.setOid(charge.getOrdernum());
        JPayment payment = new JPayment();
        charge = payment.processTransaction(request, order);
        return this.dao.getNewCreditCardCharge(charge, order, request);
    }

    private JOrder getOrder(SalesReceipt receipt, Contact billingContact) {
        JOrder order = new JOrder();
        order.setBname(billingContact.getFullName());
        order.setBcompany(billingContact.getCompanyName());
        order.setBaddr1(billingContact.getAddr1());
        order.setBaddr2(billingContact.getAddr2());
        order.setBcity(billingContact.getCity());
        order.setBstate(billingContact.getState());
        order.setBzip(billingContact.getPostalCode());
        order.setBcountry(billingContact.getCountry());
        BigDecimal total = new BigDecimal(0.0);
        List items = receipt.getLineItems();
        for (int i = 0; i < items.size(); ++i) {
            LineItem item = (LineItem)items.get(i);
            JOrderItem orderItem = this.getOrderItem(item);
            orderItem.setItemNumber(i + 1);
            order.addItems(orderItem);
            total = total.add(item.getTotalPrice());
        }
        order.setSubtotal(total.doubleValue());
        return order;
    }

    private JOrderItem getOrderItem(LineItem item) {
        JOrderItem orderItem = new JOrderItem();
        orderItem.setItemID(item.getSku().getName());
        orderItem.setESDType(0);
        orderItem.setDescription(item.getSku().getDescription());
        orderItem.setQuantity((int)item.getQuantity());
        orderItem.setPrice(item.getTotalPrice().doubleValue());
        return orderItem;
    }

    private JRequest getPreauthRequest(CreditCard card, Contact billingContact) {
        JRequest request = this.getRequest(card, billingContact);
        request.setChargeType(1);
        return request;
    }

    private JRequest getRequest(CreditCard card, Contact billingContact) {
        JRequest request = new JRequest();
        request.setHost((String)this.getConfigurationValue("jlink.host"));
        request.setPort(((Integer)this.getConfigurationValue("jlink.port")).shortValue());
        request.setCertfile((String)this.getConfigurationValue("jlink.certfile"));
        request.setKeyfile((String)this.getConfigurationValue("jlink.keyfile"));
        request.setConfigFile((String)this.getConfigurationValue("jlink.configfile"));
        request.setCardNumber(card.getCardNumber());
        request.setExpYear(card.getExpYear());
        request.setExpMonth(card.getExpMonth());
        request.setEmail(billingContact.getEmail());
        request.setZip(billingContact.getPostalCode());
        request.setResult(1);
        return request;
    }

    public void setJlinkHost(String jlinkHost) {
        this.setConfigurationValue("jlink.host", jlinkHost);
    }

    public void setJlinkPort(String jlinkPort) {
        this.setConfigurationValue("jlink.port", new Integer(jlinkPort));
    }

    public void setJlinkCertfile(String jlinkCertfile) {
        this.setConfigurationValue("jlink.certfile", jlinkCertfile);
    }

    public void setJlinkKeyfile(String jlinkKeyfile) {
        this.setConfigurationValue("jlink.keyfile", jlinkKeyfile);
    }

    public void setJlinkStorename(String jlinkStorename) {
        this.setConfigurationValue("jlink.configfile", jlinkStorename);
    }
}

