/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.rules;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.dentaku.services.rules.DroolsNativeRulesProcessor;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.io.RuleBaseBuilder;

public class DefaultDroolsNativeRulesProcessor
implements DroolsNativeRulesProcessor,
Initializable,
LogEnabled {
    private static Logger log;
    private HashMap ruleBaseStore;
    private List ruleFiles = null;

    public void enableLogging(Logger logger) {
        log = logger;
    }

    public void initialize() throws Exception {
        Iterator it = this.ruleFiles.iterator();
        while (it.hasNext()) {
            String fileName = (String)it.next();
            String identifier = null;
            if (fileName.indexOf(".drl") > 0) {
                identifier = fileName.substring(0, fileName.length() - 4);
            } else {
                identifier = fileName;
                fileName = fileName + ".drl";
            }
            identifier = identifier.substring(identifier.lastIndexOf("/") + 1);
            log.debug("Found rulebase filename " + fileName + ", identified as " + identifier);
            try {
                URL url = this.getClass().getResource(fileName);
                log.debug("loading rulebase: " + url);
                RuleBase ruleBase = RuleBaseBuilder.buildFromUrl((URL)url);
                this.setRuleBase(identifier, ruleBase);
            }
            catch (Exception e) {
                log.error("RuleBase " + identifier + " could not be loaded", (Throwable)e);
                this.setRuleBase(identifier, null);
            }
        }
    }

    public WorkingMemory getWorkingMemory(String ruleBaseIdentifier) throws Exception {
        log.debug("Create working memory for rulebase " + ruleBaseIdentifier);
        RuleBase ruleBase = this.getRuleBase(ruleBaseIdentifier);
        WorkingMemory workingMemory = ruleBase.newWorkingMemory();
        return workingMemory;
    }

    public RuleBase getRuleBase(String identifier) {
        return (RuleBase)this.getRuleBaseStore().get(identifier);
    }

    public void setRuleBase(String identifier, RuleBase ruleBase) {
        this.getRuleBaseStore().put(identifier, ruleBase);
    }

    public HashMap getRuleBaseStore() {
        if (this.ruleBaseStore == null) {
            this.ruleBaseStore = new HashMap();
        }
        return this.ruleBaseStore;
    }
}

