/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.container;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.dentaku.services.container.ContainerException;
import org.dentaku.services.container.DentakuPlexusContainer;
import org.dentaku.services.exception.DentakuException;

public class ContainerManager {
    protected DentakuPlexusContainer container;
    private static ContainerManager instance;
    protected List configurationResources = new ArrayList();

    public static ContainerManager getInstance() throws ContainerException {
        if (instance == null) {
            instance = new ContainerManager();
        }
        return instance;
    }

    public static void setInstance(ContainerManager instance) {
        ContainerManager.instance = instance;
    }

    public DentakuPlexusContainer getContainer() {
        return this.container;
    }

    public void setup() throws ContainerException {
        if (this.container == null) {
            this.container = new DentakuPlexusContainer();
            try {
                this.container.setConfigurationResources(this.configurationResources);
                this.container.initialize();
                this.container.start();
            }
            catch (Exception e) {
                throw new ContainerException(e);
            }
        }
    }

    public void setup(DentakuPlexusContainer c) {
        this.container = c;
    }

    public void add(InputStreamReader configurationResource) {
        this.configurationResources.add(configurationResource);
    }

    public Object lookup(String key) throws ComponentLookupException {
        return this.container.lookup(key);
    }

    public void dispose() {
        this.container.dispose();
        instance = null;
    }

    public static ContainerManager getContainerManager(InputStream configurationStream) throws DentakuException {
        ContainerManager containerManager = new ContainerManager();
        containerManager.add(new InputStreamReader(configurationStream));
        containerManager.setup();
        return containerManager;
    }

    public void disposeContainerManager() {
        this.dispose();
    }
}

