/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.type.Type;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.dentaku.services.persistence.ModelEntity;
import org.dentaku.services.persistence.PersistenceException;
import org.dentaku.services.persistence.PersistenceFactory;
import org.dentaku.services.persistence.PersistenceManager;
import org.dentaku.services.persistence.hibernate.SessionProvider;

public abstract class AbstractPersistenceManager
implements PersistenceManager,
Initializable {
    protected SessionProvider sessionProvider = null;
    private Map factories = null;

    public PersistenceFactory getPersistenceFactory(String name) throws PersistenceException {
        PersistenceFactory persistenceFactory = (PersistenceFactory)this.factories.get(name);
        return persistenceFactory;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    public void releaseSession() throws PersistenceException {
        this.sessionProvider.releaseSession();
    }

    public void rollback() {
        this.sessionProvider.rollback();
    }

    public void initialize() throws Exception {
        Iterator it = this.factories.values().iterator();
        while (it.hasNext()) {
            PersistenceFactory factory = (PersistenceFactory)it.next();
            factory.setManager(this);
        }
    }

    public abstract /* synthetic */ void refresh(Object var1) throws PersistenceException;

    public abstract /* synthetic */ Collection filter(Collection var1, String var2) throws PersistenceException;

    public abstract /* synthetic */ List find(String var1, Object[] var2, Type[] var3) throws PersistenceException;

    public abstract /* synthetic */ List find(String var1, Object var2, Type var3) throws PersistenceException;

    public abstract /* synthetic */ void delete(ModelEntity var1) throws PersistenceException;

    public abstract /* synthetic */ void saveOrUpdate(ModelEntity var1) throws PersistenceException;

    public abstract /* synthetic */ Object load(Class var1, Serializable var2) throws PersistenceException;
}

