/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.persistence.hibernate;

import java.lang.reflect.Method;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.dentaku.services.persistence.PersistenceException;
import org.dentaku.services.persistence.hibernate.SessionProvider;

public class ThreadLocalSessionProvider
implements SessionProvider,
LogEnabled {
    static Object hbnObject = null;
    static ThreadLocal session = new ThreadLocal();
    static ThreadLocal transaction = new ThreadLocal();
    SessionFactory factory;
    static Logger log = new ConsoleLogger(0, (class$org$dentaku$services$persistence$hibernate$ThreadLocalSessionProvider == null ? (class$org$dentaku$services$persistence$hibernate$ThreadLocalSessionProvider = ThreadLocalSessionProvider.class$("org.dentaku.services.persistence.hibernate.ThreadLocalSessionProvider")) : class$org$dentaku$services$persistence$hibernate$ThreadLocalSessionProvider).getName());
    static /* synthetic */ Class class$org$dentaku$services$persistence$hibernate$ThreadLocalSessionProvider;

    public Session getSession() throws PersistenceException {
        return ThreadLocalSessionProvider.getThreadLocalSession();
    }

    public static Session getThreadLocalSession() throws PersistenceException {
        Session sess = (Session)session.get();
        try {
            if (sess == null) {
                sess = ThreadLocalSessionProvider.getFactory().openSession();
                Transaction tr = sess.beginTransaction();
                session.set(sess);
                transaction.set(tr);
                if (log.isDebugEnabled()) {
                    log.debug("created session and started new transaction");
                }
            }
            if (!sess.isConnected()) {
                sess.reconnect();
            }
        }
        catch (HibernateException e) {
            throw new PersistenceException(e);
        }
        return sess;
    }

    public void resetSession() throws PersistenceException {
        session.set(null);
        transaction.set(null);
    }

    public void releaseSession() throws PersistenceException {
        this.releaseSessionImpl();
    }

    public void releaseSessionImpl() throws PersistenceException {
        try {
            Session session;
            Transaction tr = (Transaction)transaction.get();
            if (tr != null && !tr.wasCommitted() && !tr.wasRolledBack()) {
                transaction.set(null);
                tr.commit();
            }
            if ((session = (Session)ThreadLocalSessionProvider.session.get()) != null) {
                session.close();
                ThreadLocalSessionProvider.session.set(null);
                if (log.isDebugEnabled()) {
                    log.debug("returned session and closed it");
                }
            }
        }
        catch (HibernateException e) {
            throw new PersistenceException(e);
        }
    }

    public void rollback() {
        ThreadLocalSessionProvider.rollbackImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollbackImpl() {
        Transaction tr = (Transaction)transaction.get();
        if (tr != null) {
            try {
                tr.rollback();
            }
            catch (HibernateException hibernateException) {
            }
            finally {
                transaction.set(null);
            }
        }
    }

    public void enableLogging(Logger logger) {
        log = logger;
    }

    private static SessionFactory getFactory() throws PersistenceException {
        try {
            Method m = Class.forName("org.dentaku.container.jboss.HibernateUtil").getMethod("getSessionFactory", null);
            return (SessionFactory)m.invoke(null, null);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

