/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.rules;

import java.io.InputStream;
import java.util.HashMap;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.DirectoryScanner;
import org.dentaku.services.rules.DroolsNativeRulesProcessor;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.io.RuleBaseBuilder;

public class DefaultDroolsNativeRulesProcessor
implements DroolsNativeRulesProcessor,
Initializable,
LogEnabled {
    private static Logger log;
    private HashMap ruleBaseStore;
    String ruleFilesDirectory;
    String ruleFilesIncludes;

    public void enableLogging(Logger logger) {
        log = logger;
    }

    public void initialize() throws Exception {
        String identifier = null;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.ruleFilesDirectory);
        scanner.setIncludes(new String[]{this.ruleFilesIncludes});
        scanner.scan();
        String[] fileNames = scanner.getIncludedFiles();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            if (fileName.indexOf(".drl") > 0) {
                identifier = fileName.substring(0, fileName.length() - 4);
            } else {
                identifier = fileName;
                fileName = fileName + ".drl";
            }
            identifier = identifier.substring(identifier.lastIndexOf("/") + 1);
            log.debug("Found rulebase filename " + fileName + ", identified as " + identifier);
            InputStream resourceAsStream = this.getClass().getResourceAsStream(fileName);
            try {
                RuleBase ruleBase = RuleBaseBuilder.buildFromInputStream((InputStream)resourceAsStream);
                this.setRuleBase(identifier, ruleBase);
                continue;
            }
            catch (Exception e) {
                log.error("RuleBase " + identifier + " could not be loaded", (Throwable)e);
                this.setRuleBase(identifier, null);
            }
        }
    }

    public WorkingMemory getWorkingMemory(String ruleBaseIdentifier) throws Exception {
        log.debug("Create working memory for rulebase " + ruleBaseIdentifier);
        RuleBase ruleBase = this.getRuleBase(ruleBaseIdentifier);
        WorkingMemory workingMemory = ruleBase.newWorkingMemory();
        return workingMemory;
    }

    public RuleBase getRuleBase(String identifier) {
        return (RuleBase)this.getRuleBaseStore().get(identifier);
    }

    public void setRuleBase(String identifier, RuleBase ruleBase) {
        this.getRuleBaseStore().put(identifier, ruleBase);
    }

    public HashMap getRuleBaseStore() {
        if (this.ruleBaseStore == null) {
            this.ruleBaseStore = new HashMap();
        }
        return this.ruleBaseStore;
    }
}

