/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.ldap.clients.BindOpts;

public class AddOpts
extends BindOpts {
    private String addedDn;
    private String ldifFile;

    public String getAddedDn() {
        return this.addedDn;
    }

    public boolean usesLdifFile() {
        return this.ldifFile != null;
    }

    public String getLdifFile() {
        return this.ldifFile;
    }

    public void process(String[] argv) throws ParseException {
        this.options.addOption(hostOption);
        this.options.addOption(portOption);
        this.options.addOption(bindDnOption);
        this.options.addOption(nothingOption);
        this.options.addOption(protocolOption);
        this.options.addOption(passwordOption);
        this.options.addOption(verboseOption);
        this.options.addOption(fileOption);
        CommandLine cl = this.getParser(argv, this.options);
        this.host = cl.getOptionValue("h", "localhost");
        this.port = Integer.parseInt(cl.getOptionValue("p", "389"));
        this.bindDn = cl.getOptionValue("D", "");
        this.isDryRun = cl.hasOption("n");
        this.isVersion3 = Integer.parseInt(cl.getOptionValue("P", "3")) == 3;
        this.password = cl.getOptionValue("w", "");
        this.isVerbose = cl.hasOption("v");
        this.ldifFile = cl.getOptionValue("f", null);
        if (this.ldifFile == null) {
            throw new ParseException("No ldif file given");
        }
        String[] leftArgs = cl.getArgs();
        if (leftArgs == null || leftArgs.length == 0) {
            throw new ParseException("A Distinguised Name (DN) must be given");
        }
        this.addedDn = leftArgs[0];
        super.setProcessed();
    }
}

