/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ldap.clients.Opts;

public class BindOpts
extends Opts {
    Options options = new Options();
    public static final String DEFAULT_PORT = "389";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_MAX_ENTRIES = "1000";
    public static final String DEFAULT_MAX_TIME = "1000";
    protected int port;
    protected boolean isDryRun;
    protected boolean isVerbose;
    protected boolean isVersion3;
    protected String host;
    protected String bindDn;
    protected String password;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBindDn(String bindDn) {
        this.bindDn = bindDn;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIsVersion3(boolean isVersion3) {
        this.isVersion3 = isVersion3;
    }

    public void setIsVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void setIsDryRun(boolean isDryRun) {
        this.isDryRun = isDryRun;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isVersion3() {
        return this.isVersion3;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    public Options getOptions() {
        return this.options;
    }

    public void process(String[] argv) throws ParseException {
        this.options.addOption(hostOption);
        this.options.addOption(portOption);
        this.options.addOption(bindDnOption);
        this.options.addOption(nothingOption);
        this.options.addOption(protocolOption);
        this.options.addOption(passwordOption);
        this.options.addOption(verboseOption);
        CommandLine cl = this.getParser(argv, this.options);
        this.host = cl.getOptionValue("h", DEFAULT_HOST);
        this.port = Integer.parseInt(cl.getOptionValue("p", DEFAULT_PORT));
        this.bindDn = cl.getOptionValue("D", "");
        this.isDryRun = cl.hasOption("n");
        this.isVersion3 = Integer.parseInt(cl.getOptionValue("P", "3")) == 3;
        this.password = cl.getOptionValue("w", "");
        this.isVerbose = cl.hasOption("v");
        super.setProcessed();
    }
}

