/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.ldap.clients.AddOpts;
import org.apache.ldap.clients.LdapBind;
import org.apache.ldap.common.ldif.LdifParserImpl;
import org.apache.ldap.common.message.AddRequestImpl;
import org.apache.ldap.common.message.AddResponse;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.ResultCodeEnum;

public class LdapAdd
extends LdapBind {
    private String module = "LdapAdd";

    public LdapAdd(String[] args) {
        super(args);
    }

    public InputStream getStream() {
        AddOpts opts = (AddOpts)super.getOpts();
        InputStream stream = null;
        if (opts.usesLdifFile()) {
            try {
                stream = new FileInputStream(opts.getLdifFile());
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open LDIF file " + opts.getLdifFile());
                System.exit(-1);
            }
        } else {
            stream = System.in;
        }
        return stream;
    }

    public void parseInput(InputStream inputStream) {
        String line = new String();
        StringBuffer buf = new StringBuffer();
        int messageNum = 2;
        BufferedReader stream = new BufferedReader(new InputStreamReader(inputStream));
        try {
            while ((line = stream.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.trim().equals("")) {
                    this.add(buf, messageNum);
                    ++messageNum;
                    buf.setLength(0);
                    continue;
                }
                buf.append(line);
                buf.append('\n');
            }
        }
        catch (IOException e) {
            this.getLog().error((Object)("error reading from input " + e.toString()));
            System.exit(-1);
        }
        this.add(buf, messageNum);
    }

    public void add(StringBuffer buf, int msgId) {
        AddRequestImpl request = new AddRequestImpl(msgId);
        try {
            String dn = new String();
            LdifParserImpl parser = new LdifParserImpl();
            BasicAttributes attributes = new BasicAttributes();
            parser.parse((Attributes)attributes, buf.toString());
            Attribute attr = attributes.get("dn");
            if (attr == null) {
                return;
            }
            dn = (String)attr.get();
            request.setName(dn);
            attributes.remove("dn");
            request.setEntry((Attributes)attributes);
        }
        catch (NamingException ne) {
            System.out.println("Error parsing file " + ne.toString());
            System.exit(-1);
        }
        super.getEncoder().encodeBlocking(null, super.getOut(), (Object)request);
        AddResponse l_addResponse = (AddResponse)super.getDecoder().decode(null, super.getIn());
        LdapResult l_result = l_addResponse.getLdapResult();
        if (l_result.getResultCode() == ResultCodeEnum.SUCCESS) {
            this.getLog().info((Object)("Add of Entry " + request.getName() + " was successful"));
        } else {
            this.getLog().error((Object)("Add of entry " + request.getName() + " failed for the following reasons provided by the server:\n" + new String(l_result.getErrorMessage())));
        }
    }

    public static void main(String[] args) {
        LdapAdd client = new LdapAdd(args);
        BindResponse bindResponse = null;
        try {
            bindResponse = client.bind(1);
        }
        catch (MessageException e) {
            System.out.println("Failed to bind to server due to message composition failure" + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Failed to bind to server " + e.getMessage());
            System.exit(1);
        }
        client.getLog().debug((Object)"Got back BindResponse from the server:\n");
        LdapResult result = bindResponse.getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " was successful");
        } else {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " failed for the following reasons provided by the server:\n" + new String(result.getErrorMessage()));
            System.exit(-1);
        }
        InputStream inStream = client.getStream();
        client.parseInput(inStream);
        try {
            client.disconnect();
        }
        catch (IOException e) {
            client.getLog().error((Object)"Failed to close client connection!", (Throwable)e);
        }
    }
}

