/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.apache.ldap.clients.BindOpts;
import org.apache.ldap.common.message.BindRequestImpl;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.MessageDecoder;
import org.apache.ldap.common.message.MessageEncoder;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LdapBind {
    private static Logger log = Logger.getLogger((Class)(class$org$apache$ldap$clients$LdapBind == null ? (class$org$apache$ldap$clients$LdapBind = LdapBind.class$("org.apache.ldap.clients.LdapBind")) : class$org$apache$ldap$clients$LdapBind));
    private String module = "LdapBind";
    private InputStream in = null;
    private OutputStream out = null;
    private MessageDecoder decoder = null;
    private MessageEncoder encoder = null;
    private static BindOpts opts;
    private Socket socket = null;
    static /* synthetic */ Class class$org$apache$ldap$clients$LdapBind;

    public String getModule() {
        return this.module;
    }

    public void enableLogging(Level level) {
        log.setLevel(level);
    }

    public MessageDecoder getDecoder() {
        return this.decoder;
    }

    public MessageEncoder getEncoder() {
        return this.encoder;
    }

    public InputStream getIn() {
        return this.in;
    }

    public Logger getLog() {
        return log;
    }

    public BindOpts getOpts() {
        return opts;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setDecoder(MessageDecoder decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(MessageEncoder encoder) {
        this.encoder = encoder;
    }

    public void setIn(InputStream stream) {
        this.in = stream;
    }

    public void setLog(Logger logger) {
        log = logger;
    }

    public void setOpts(BindOpts opts) {
        LdapBind.opts = opts;
    }

    public void setOut(OutputStream stream) {
        this.out = stream;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public LdapBind(String[] argv) {
        try {
            opts = new BindOpts();
            opts.process(argv);
        }
        catch (ParseException pe) {
            System.out.println("Error while parsing command line arguments : " + pe.getMessage());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < argv.length; ++i) {
                sb.append(argv[i]).append(' ');
            }
            System.out.println("Command line arguments : " + sb.toString());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(this.module, opts.getOptions());
            System.exit(1);
        }
        if (opts.isVerbose()) {
            this.enableLogging(Level.DEBUG);
        } else {
            this.enableLogging(Level.INFO);
        }
    }

    public void connect() throws UnknownHostException, IOException {
        InetAddress l_address = InetAddress.getByName(opts.getHost());
        this.socket = new Socket(l_address, opts.getPort());
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.encoder = new MessageEncoder();
        this.in = this.socket.getInputStream();
        this.decoder = new MessageDecoder();
    }

    public BindResponse bind(int id) throws UnknownHostException, IOException {
        BindRequestImpl request = new BindRequestImpl(id);
        request.setName(opts.getBindDn());
        request.setSimple(true);
        request.setCredentials(opts.getPassword().getBytes());
        request.setVersion3(opts.isVersion3());
        if (this.socket == null) {
            this.connect();
        }
        this.encoder.encodeBlocking(null, this.out, (Object)request);
        return (BindResponse)this.decoder.decode(null, this.in);
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        BindResponse response;
        LdapBind client;
        block10: {
            client = new LdapBind(args);
            response = null;
            response = client.bind(1);
            Object var5_3 = null;
            try {
                client.disconnect();
            }
            catch (Throwable t) {
                client.getLog().error((Object)"Error while closing socket connection", t);
            }
            break block10;
            {
                catch (IOException e) {
                    client.getLog().fatal((Object)"Failed to transmit pdu to server", (Throwable)e);
                    System.exit(1);
                    Object var5_4 = null;
                    try {
                        client.disconnect();
                    }
                    catch (Throwable t) {
                        client.getLog().error((Object)"Error while closing socket connection", t);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    client.disconnect();
                }
                catch (Throwable t) {
                    client.getLog().error((Object)"Error while closing socket connection", t);
                }
                throw throwable;
            }
        }
        client.getLog().debug((Object)"Got back BindResponse from the server:\n");
        LdapResult result = response.getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " was successful");
        } else {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " failed for the following reasons provided by the server:\n" + new String(result.getErrorMessage()));
            System.exit(-1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BasicConfigurator.configure();
        opts = null;
    }
}

