/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import java.io.IOException;
import org.apache.ldap.clients.DelOpts;
import org.apache.ldap.clients.LdapBind;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.DeleteRequestImpl;
import org.apache.ldap.common.message.DeleteResponse;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.ResultCodeEnum;

public class LdapDel
extends LdapBind {
    private String module = "LdapDel";

    public LdapDel(String[] args) {
        super(args);
    }

    public DeleteResponse delete(int id) {
        DelOpts opts = (DelOpts)super.getOpts();
        DeleteRequestImpl request = new DeleteRequestImpl(id);
        request.setName(opts.getDeletedDn());
        super.getEncoder().encodeBlocking(null, super.getOut(), (Object)request);
        return (DeleteResponse)super.getDecoder().decode(null, super.getIn());
    }

    public static void main(String[] args) {
        LdapDel client = new LdapDel(args);
        BindResponse bindResponse = null;
        try {
            bindResponse = client.bind(1);
        }
        catch (MessageException e) {
            System.out.println("Failed to bind to server due to message composition failure" + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Failed to bind to server" + e.getMessage());
            System.exit(1);
        }
        client.getLog().debug((Object)"Got back BindResponse from the server:\n");
        LdapResult result = bindResponse.getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            client.getLog().info((Object)("Authentication for " + client.getOpts().getBindDn() + " was successful"));
        } else {
            client.getLog().error((Object)("Authentication for " + client.getOpts().getBindDn() + " failed for the following reasons provided by the server:\n" + new String(result.getErrorMessage())));
            System.exit(-1);
        }
        DeleteResponse l_delResponse = client.delete(2);
        result = l_delResponse.getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            System.out.println("Delete of entry " + ((DelOpts)client.getOpts()).getDeletedDn() + " was successful");
        } else {
            System.out.println("Delete of entry " + ((DelOpts)client.getOpts()).getDeletedDn() + " failed for the following reasons provided by the server:\n" + new String(result.getErrorMessage()));
            System.exit(-1);
        }
        try {
            client.disconnect();
        }
        catch (IOException e) {
            client.getLog().error((Object)"Failed to close client connection!", (Throwable)e);
        }
    }
}

