/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import javax.naming.NamingException;
import javax.naming.directory.ModificationItem;
import org.apache.ldap.clients.LdapBind;
import org.apache.ldap.clients.ModifyOpts;
import org.apache.ldap.common.ldif.LdifEntry;
import org.apache.ldap.common.ldif.LdifParserImpl;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.ModifyRequestImpl;
import org.apache.ldap.common.message.ModifyResponse;
import org.apache.ldap.common.message.ResultCodeEnum;

public class LdapModify
extends LdapBind {
    private String module = "LdapModify";

    public LdapModify(String[] args) {
        super(args);
    }

    public InputStream getStream() {
        ModifyOpts opts = (ModifyOpts)super.getOpts();
        InputStream stream = null;
        if (opts.usesLdifFile()) {
            try {
                stream = new FileInputStream(opts.getLdifFile());
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not open LDIF file " + opts.getLdifFile());
                System.exit(-1);
            }
        } else {
            stream = System.in;
        }
        return stream;
    }

    public void parseInput(InputStream a_stream) {
        String line = new String();
        StringBuffer buf = new StringBuffer();
        int messageNum = 2;
        BufferedReader stream = new BufferedReader(new InputStreamReader(a_stream));
        try {
            while ((line = stream.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.trim().equals("")) {
                    this.modify(buf, messageNum);
                    ++messageNum;
                    buf.setLength(0);
                    continue;
                }
                buf.append(line);
                buf.append('\n');
            }
        }
        catch (IOException e) {
            System.out.println("error reading from input " + e.toString());
            System.exit(-1);
        }
        this.modify(buf, messageNum);
    }

    public void modify(StringBuffer a_buf, int id) {
        ModifyRequestImpl request = new ModifyRequestImpl(id);
        try {
            LdifParserImpl parser = new LdifParserImpl();
            LdifEntry ldifEntry = null;
            ldifEntry = parser.parse(a_buf.toString());
            request.setName(ldifEntry.getDn());
            LinkedList items = ldifEntry.getModificationItems();
            for (int index = 0; index < items.size(); ++index) {
                request.addModification((ModificationItem)items.get(index));
            }
        }
        catch (NamingException ne) {
            System.out.println("Error parsing file " + ne.toString());
            System.exit(-1);
        }
        super.getEncoder().encodeBlocking(null, super.getOut(), (Object)request);
        ModifyResponse modifyResponse = (ModifyResponse)super.getDecoder().decode(null, super.getIn());
        LdapResult result = modifyResponse.getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            System.out.println("Modify of Entry " + request.getName() + " was successful");
        } else {
            System.out.println("Modify of entry " + request.getName() + " failed for the following reasons provided by the server:\n" + new String(result.getErrorMessage()));
        }
    }

    public static void main(String[] args) {
        LdapModify client = new LdapModify(args);
        BindResponse bindResponse = null;
        try {
            bindResponse = client.bind(1);
        }
        catch (MessageException e) {
            System.out.println("Failed to bind to server due to message composition failure" + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Failed to bind to server" + e.getMessage());
            System.exit(1);
        }
        client.getLog().debug((Object)"Got back BindResponse from the server:\n");
        LdapResult result = bindResponse.getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " was successful");
        } else {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " failed for the following reasons provided by the server:\n" + new String(result.getErrorMessage()));
            System.exit(-1);
        }
        InputStream inStream = client.getStream();
        client.parseInput(inStream);
        try {
            client.disconnect();
        }
        catch (IOException e) {
            client.getLog().error((Object)"Failed to close client connection!", (Throwable)e);
        }
    }
}

