/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import java.io.IOException;
import java.text.ParseException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.ldap.clients.LdapBind;
import org.apache.ldap.clients.SearchOpts;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.FilterParserImpl;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.SearchRequest;
import org.apache.ldap.common.message.SearchRequestImpl;
import org.apache.ldap.common.message.SearchResponseDoneImpl;
import org.apache.ldap.common.message.SearchResponseEntryImpl;

public class LdapSearch
extends LdapBind {
    public LdapSearch(String[] args) {
        super(args);
    }

    public String requestToString(SearchRequest a_request) {
        String l_requestString = new String("\t\t\t\tBase DN: " + a_request.getBase() + "\n\t\t\t\tDereference Alias: " + a_request.getDerefAliases().getName().toString() + "[" + a_request.getDerefAliases().getValue() + "]" + "\n\t\t\t\tFilter: " + a_request.getFilter() + "\n\t\t\t\tMessage ID: " + a_request.getMessageId() + "\n\t\t\t\tSize Limit: " + a_request.getSizeLimit() + "\n\t\t\t\tTime Limit: " + a_request.getTimeLimit() + "\n\t\t\t\tTypes Only: " + a_request.getTypesOnly() + "\n\t\t\t\tScope: " + a_request.getScope().getName().toString() + "[" + a_request.getScope().getValue() + "]");
        return l_requestString;
    }

    public void printAttributeNames(NamingEnumeration a_attributeList) {
        while (a_attributeList.hasMoreElements()) {
            Attribute l_attr = (Attribute)a_attributeList.nextElement();
            System.out.println(l_attr.getID());
        }
    }

    public void printAttributeList(NamingEnumeration a_attributeList) {
        while (a_attributeList.hasMoreElements()) {
            Attribute l_attr = (Attribute)a_attributeList.nextElement();
            try {
                NamingEnumeration<?> l_attrValues = l_attr.getAll();
                while (l_attrValues.hasMoreElements()) {
                    System.out.print(l_attr.getID() + "=");
                    System.out.println(l_attrValues.nextElement().toString());
                }
            }
            catch (NamingException e) {
                System.out.println("Naming Exception thrown retreiving values for attribute " + l_attr.getID());
            }
        }
    }

    public void search(int id) {
        SearchOpts opts = (SearchOpts)super.getOpts();
        SearchRequestImpl request = new SearchRequestImpl(id);
        Object response = new Object();
        SearchResponseDoneImpl searchResponseDone = new SearchResponseDoneImpl(1);
        FilterParserImpl filter = null;
        ExprNode expr = null;
        filter = new FilterParserImpl();
        try {
            expr = filter.parse(opts.getFilter());
        }
        catch (ParseException pe) {
            this.getLog().fatal((Object)"Parsing Exception ", (Throwable)pe);
            System.exit(1);
        }
        catch (IOException ioe) {
            this.getLog().fatal((Object)"IO Error while parsing the filter ", (Throwable)ioe);
            System.exit(1);
        }
        this.getLog().debug((Object)("Sucessfully paresed the filter: " + opts.getFilter()));
        request.setFilter(expr);
        request.setBase(opts.getBase());
        request.setScope(opts.getScope());
        request.setDerefAliases(DerefAliasesEnum.NEVERDEREFALIASES);
        request.setTimeLimit(opts.getMaxTime());
        request.setSizeLimit(opts.getMaxEntries());
        request.setTypesOnly(opts.isTypesMode());
        this.getLog().debug((Object)("Sending the following request to the ldap server " + opts.getHost() + ":" + opts.getPort() + "\n" + this.requestToString((SearchRequest)request)));
        super.getEncoder().encodeBlocking(null, super.getOut(), (Object)request);
        response = super.getDecoder().decode(null, super.getIn());
        while (!response.getClass().isInstance(searchResponseDone)) {
            SearchResponseEntryImpl searchResponseEntry = (SearchResponseEntryImpl)response;
            System.out.println(searchResponseEntry.getObjectName());
            if (opts.isTypesMode()) {
                this.printAttributeNames(searchResponseEntry.getAttributes().getAll());
            } else if (!opts.isQuietMode()) {
                this.printAttributeList(searchResponseEntry.getAttributes().getAll());
            }
            System.out.println();
            response = super.getDecoder().decode(null, super.getIn());
        }
        searchResponseDone = (SearchResponseDoneImpl)response;
        if (searchResponseDone.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            System.out.println("Search failed for the following reasons :\n" + new String(searchResponseDone.getLdapResult().getErrorMessage()));
            System.exit(-1);
        } else {
            this.getLog().debug((Object)("Search with filter " + opts.getFilter() + " was successful"));
        }
    }

    public static void main(String[] args) {
        LdapSearch client = new LdapSearch(args);
        BindResponse bindResponse = null;
        try {
            bindResponse = client.bind(1);
        }
        catch (MessageException e) {
            System.out.println("Failed to bind to server due to message composition failure" + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Failed to bind to server" + e.getMessage());
            System.exit(1);
        }
        client.getLog().debug((Object)"Got back BindResponse from the server:\n");
        LdapResult result = bindResponse.getLdapResult();
        if (result.getResultCode() == ResultCodeEnum.SUCCESS) {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " was successful");
        } else {
            System.out.println("Authentication for " + client.getOpts().getBindDn() + " failed for the following reasons provided by the server:\n" + new String(result.getErrorMessage()));
            System.exit(-1);
        }
        client.search(2);
        try {
            client.disconnect();
        }
        catch (IOException e) {
            client.getLog().error((Object)"Failed to close client connection!", (Throwable)e);
        }
    }
}

