/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class Opts {
    private static final boolean ARGUMENT_REQUIRED = true;
    private static final boolean NO_ARGUMENT = false;
    private boolean isProcessed = false;
    private Options options = new Options();
    protected static final String HOST_OPT = "h";
    protected static final Option hostOption = new Option("h", "host", true, "LDAP server");
    protected static final String PORT_OPT = "p";
    protected static final Option portOption = new Option("p", "port", true, "port on LDAP server");
    protected static final String BINDDN_OPT = "D";
    protected static final Option bindDnOption = new Option("D", "binddn", true, "bind DN");
    protected static final String NOTHING_OPT = "n";
    protected static final Option nothingOption = new Option("n", "noupdate", true, "show what would be done but don't actually update");
    protected static final String PROTOCOL_OPT = "P";
    protected static final Option protocolOption = new Option("P", "protocol", true, "procotol version (default: 3)");
    protected static final String PASSWORD_OPT = "w";
    protected static final Option passwordOption = new Option("w", "passwd", true, "bind passwd (for simple authentication)");
    protected static final String VERBOSE_OPT = "v";
    protected static final Option verboseOption = new Option("v", "verbose", false, "run in verbose mode (diagnostics to standard output)");
    protected static final String FILE_OPT = "f";
    protected static final Option fileOption = new Option("f", "file", true, "LDIF file used instead of Standard Input");
    protected static final String BASEDN_OPT = "b";
    protected static final Option baseDnOption = new Option("b", "baseDN", true, "Base DN to start the search from");
    protected static final String SCOPE_OPT = "s";
    protected static final Option scopeOption = new Option("s", "scope", true, "Search scope, either base, one or sub");
    protected static final String QUIET_OPT = "q";
    protected static final Option quietOption = new Option("q", "quiet", false, "Quiet mode, only print the entry DN, no attributes");
    protected static final String TYPES_OPT = "A";
    protected static final Option typesOption = new Option("A", "types", true, "Types only, only display attribute name, no values");
    protected static final String MAX_ENTRIES_OPT = "z";
    protected static final Option maxEntriesOption = new Option("z", "max-entries", true, "Maximum number of entries to be returned from the server");
    protected static final String MAX_TIME_OPT = "l";
    protected static final Option maxTimeOption = new Option("l", "max-time", true, "The  number of seconds to wait for a response from the server");

    protected CommandLine getParser(String[] argv, Options options) throws ParseException {
        BasicParser parser = new BasicParser();
        return parser.parse(options, argv);
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public void setProcessed() {
        this.isProcessed = true;
    }

    public abstract void process(String[] var1) throws ParseException;
}

