/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.ldap.clients.BindOpts;
import org.apache.ldap.common.message.ScopeEnum;

public class SearchOpts
extends BindOpts {
    private String filter;
    private String base;
    private ScopeEnum scope = ScopeEnum.SINGLELEVEL;
    private boolean quietMode = false;
    private boolean typesMode = false;
    private int maxEntries = 0;
    private int maxTime = 0;

    public String getBase() {
        return this.base;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public boolean isQuietMode() {
        return this.quietMode;
    }

    public boolean isTypesMode() {
        return this.typesMode;
    }

    public ScopeEnum getScope() {
        return this.scope;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }

    public void setTypesMode(boolean typesMode) {
        this.typesMode = typesMode;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public void process(String[] argv) throws ParseException {
        this.options.addOption(hostOption);
        this.options.addOption(portOption);
        this.options.addOption(bindDnOption);
        this.options.addOption(nothingOption);
        this.options.addOption(protocolOption);
        this.options.addOption(passwordOption);
        this.options.addOption(verboseOption);
        this.options.addOption(fileOption);
        this.options.addOption(maxEntriesOption);
        this.options.addOption(maxTimeOption);
        CommandLine cl = this.getParser(argv, this.options);
        this.host = cl.getOptionValue("h", "localhost");
        this.port = Integer.parseInt(cl.getOptionValue("p", "389"));
        this.bindDn = cl.getOptionValue("D", "");
        this.isDryRun = cl.hasOption("n");
        this.isVersion3 = Integer.parseInt(cl.getOptionValue("P", "3")) == 3;
        this.password = cl.getOptionValue("w", "");
        this.isVerbose = cl.hasOption("v");
        this.base = cl.getOptionValue("b", "");
        this.filter = cl.getOptionValue("f", null);
        if (this.filter == null) {
            throw new ParseException("No filter given");
        }
        this.typesMode = cl.hasOption("A");
        this.quietMode = cl.hasOption("q");
        if (this.typesMode & this.quietMode) {
            throw new ParseException("Cannot have quiet mode (-q) andTypes Only mode (-A) both turned on");
        }
        String scopeString = cl.getOptionValue("s", "");
        if (scopeString.equalsIgnoreCase("base")) {
            this.scope = ScopeEnum.BASEOBJECT;
        } else if (scopeString.equalsIgnoreCase("one")) {
            this.scope = ScopeEnum.SINGLELEVEL;
        } else if (scopeString.equalsIgnoreCase("sub")) {
            this.scope = ScopeEnum.WHOLESUBTREE;
        } else {
            throw new ParseException("Value for scope must be one of the following: base, one, sub");
        }
        try {
            this.maxEntries = Math.abs(Integer.parseInt(cl.getOptionValue("z", "1000")));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("MaxEntries parameter does not contains a valid value");
        }
        try {
            this.maxTime = Math.abs(Integer.parseInt(cl.getOptionValue("l", "1000")));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("MaxTime parameter does not contains a valid value");
        }
        super.setProcessed();
    }
}

