/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients.embedded;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.LinkedList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.apache.ldap.clients.embedded.LdapClient;
import org.apache.ldap.clients.embedded.LdapClientResponse;
import org.apache.ldap.clients.embedded.LdapSearchParameters;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.FilterParserImpl;
import org.apache.ldap.common.ldif.LdifEntry;
import org.apache.ldap.common.ldif.LdifParserImpl;
import org.apache.ldap.common.message.AddRequestImpl;
import org.apache.ldap.common.message.AddResponse;
import org.apache.ldap.common.message.BindRequestImpl;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.DeleteRequestImpl;
import org.apache.ldap.common.message.DeleteResponse;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.common.message.MessageDecoder;
import org.apache.ldap.common.message.MessageEncoder;
import org.apache.ldap.common.message.ModifyRequestImpl;
import org.apache.ldap.common.message.ModifyResponse;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.SearchRequestImpl;
import org.apache.ldap.common.message.SearchResponseDoneImpl;
import org.apache.ldap.common.message.SearchResponseEntryImpl;
import org.apache.ldap.common.message.UnbindRequestImpl;

public class LdapClientImpl
implements LdapClient {
    public static final int DEFAULT_PORT = 1396;
    public static final String DEFAULT_HOST = "192.168.0.100";
    private int m_port = 1396;
    private boolean m_isDryRun = false;
    private boolean m_isVerbose = false;
    private boolean m_isVersion3 = true;
    private String m_host = "192.168.0.100";
    private String m_bindDn = "";
    private String m_password = "";
    private int id = 1;
    private Socket m_socket = null;

    public void setHost(String a_host) {
        this.m_host = a_host;
    }

    public void setPort(int a_port) {
        this.m_port = a_port;
    }

    public void setBindDn(String a_bindDn) {
        this.m_bindDn = a_bindDn;
    }

    public void setPassword(String a_password) {
        this.m_password = a_password;
    }

    public void setIsVersion3(boolean a_isVersion3) {
        this.m_isVersion3 = a_isVersion3;
    }

    public void setIsVerbose(boolean a_isVerbose) {
        this.m_isVerbose = a_isVerbose;
    }

    public void setIsDryRun(boolean a_isDryRun) {
        this.m_isDryRun = a_isDryRun;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getBindDn() {
        return this.m_bindDn;
    }

    public String getPassword() {
        return this.m_password;
    }

    public boolean isVersion3() {
        return this.m_isVersion3;
    }

    public boolean isVerbose() {
        return this.m_isVerbose;
    }

    public boolean isDryRun() {
        return this.m_isDryRun;
    }

    public void connectToServer() throws UnknownHostException, IOException {
        InetAddress l_address = InetAddress.getByName(this.m_host);
        this.m_socket = new Socket(l_address, this.m_port);
        this.m_socket.setKeepAlive(true);
    }

    public boolean isConnectedToServer() {
        boolean isConnected = false;
        if (this.m_socket != null) {
            isConnected = this.m_socket.isConnected();
        }
        return isConnected;
    }

    public void closeServerConnection() throws IOException {
        this.m_socket.close();
    }

    public LdapClientResponse ldapBind() throws IOException {
        if (!this.isConnectedToServer()) {
            this.connectToServer();
        }
        BindRequestImpl l_request = new BindRequestImpl(this.id);
        l_request.setName(this.m_bindDn);
        l_request.setSimple(true);
        l_request.setCredentials(this.m_password.getBytes());
        l_request.setVersion3(this.m_isVersion3);
        MessageEncoder l_encoder = new MessageEncoder();
        MessageDecoder l_decoder = new MessageDecoder();
        l_encoder.encodeBlocking(null, this.m_socket.getOutputStream(), (Object)l_request);
        ++this.id;
        BindResponse l_bindResponse = (BindResponse)l_decoder.decode(null, this.m_socket.getInputStream());
        LdapClientResponse l_clientResponse = new LdapClientResponse();
        l_clientResponse.setResultCode(l_bindResponse.getLdapResult().getResultCode().getValue());
        l_clientResponse.setErrorMessage(l_bindResponse.getLdapResult().getErrorMessage());
        l_clientResponse.setResultCodeString(l_bindResponse.getLdapResult().getResultCode().toString());
        return l_clientResponse;
    }

    public void printLdapBindResponse(BindResponse a_response) throws IOException {
    }

    public void ldapUnbind() throws IOException {
        UnbindRequestImpl l_request = new UnbindRequestImpl(this.id);
        MessageEncoder l_encoder = new MessageEncoder();
        l_encoder.encodeBlocking(null, this.m_socket.getOutputStream(), (Object)l_request);
        ++this.id;
        this.m_socket.close();
    }

    public LdapClientResponse ldapDelete(String a_deleteDn) throws IOException {
        DeleteRequestImpl l_request = new DeleteRequestImpl(this.id);
        l_request.setName(a_deleteDn);
        MessageEncoder l_encoder = new MessageEncoder();
        MessageDecoder l_decoder = new MessageDecoder();
        l_encoder.encodeBlocking(null, this.m_socket.getOutputStream(), (Object)l_request);
        ++this.id;
        DeleteResponse l_deleteResponse = (DeleteResponse)l_decoder.decode(null, this.m_socket.getInputStream());
        LdapClientResponse l_clientResponse = new LdapClientResponse();
        l_clientResponse.setResultCode(l_deleteResponse.getLdapResult().getResultCode().getValue());
        l_clientResponse.setErrorMessage(l_deleteResponse.getLdapResult().getErrorMessage());
        l_clientResponse.setResultCodeString(l_deleteResponse.getLdapResult().getResultCode().toString());
        return l_clientResponse;
    }

    public LdapClientResponse ldapAdd(StringBuffer a_entry) throws IOException {
        MessageEncoder l_encoder = new MessageEncoder();
        MessageDecoder l_decoder = new MessageDecoder();
        AddRequestImpl l_request = new AddRequestImpl(this.id);
        ++this.id;
        try {
            String l_dn = new String();
            LdifParserImpl l_parser = new LdifParserImpl();
            BasicAttributes l_attributes = new BasicAttributes();
            l_parser.parse((Attributes)l_attributes, a_entry.toString());
            Attribute l_attr = l_attributes.get("dn");
            if (l_attr == null) {
                return null;
            }
            l_dn = (String)l_attr.get();
            l_request.setName(l_dn);
            l_attributes.remove("dn");
            l_request.setEntry((Attributes)l_attributes);
        }
        catch (NamingException ne) {
            System.out.println("Error parsing file " + ne.toString());
            System.exit(-1);
        }
        l_encoder.encodeBlocking(null, this.m_socket.getOutputStream(), (Object)l_request);
        AddResponse l_addResponse = (AddResponse)l_decoder.decode(null, this.m_socket.getInputStream());
        LdapClientResponse l_clientResponse = new LdapClientResponse();
        l_clientResponse.setResultCode(l_addResponse.getLdapResult().getResultCode().getValue());
        l_clientResponse.setErrorMessage(l_addResponse.getLdapResult().getErrorMessage());
        l_clientResponse.setResultCodeString(l_addResponse.getLdapResult().getResultCode().toString());
        l_clientResponse.setDn(l_request.getName());
        return l_clientResponse;
    }

    public LdapClientResponse ldapModify(StringBuffer a_entry) throws IOException {
        LdapClientResponse l_clientResponse = new LdapClientResponse();
        MessageEncoder l_encoder = new MessageEncoder();
        MessageDecoder l_decoder = new MessageDecoder();
        ModifyRequestImpl l_request = new ModifyRequestImpl(this.id);
        ++this.id;
        try {
            LdifParserImpl l_parser = new LdifParserImpl();
            LdifEntry l_ldifEntry = null;
            l_ldifEntry = l_parser.parse(a_entry.toString());
            l_request.setName(l_ldifEntry.getDn());
            LinkedList l_items = l_ldifEntry.getModificationItems();
            for (int l_index = 0; l_index < l_items.size(); ++l_index) {
                l_request.addModification((ModificationItem)l_items.get(l_index));
            }
        }
        catch (NamingException ne) {
            System.out.println("Error parsing file " + ne.toString());
            System.exit(-1);
        }
        l_encoder.encodeBlocking(null, this.m_socket.getOutputStream(), (Object)l_request);
        ModifyResponse l_modifyResponse = (ModifyResponse)l_decoder.decode(null, this.m_socket.getInputStream());
        l_clientResponse.setResultCode(l_modifyResponse.getLdapResult().getResultCode().getValue());
        l_clientResponse.setErrorMessage(l_modifyResponse.getLdapResult().getErrorMessage());
        l_clientResponse.setResultCodeString(l_modifyResponse.getLdapResult().getResultCode().toString());
        l_clientResponse.setDn(l_request.getName());
        return l_clientResponse;
    }

    public LdapClientResponse ldapSearch(LdapSearchParameters a_parms) throws IOException {
        LdapClientResponse l_clientReponse = new LdapClientResponse();
        Object l_response = new Object();
        SearchResponseDoneImpl l_searchResponseDone = new SearchResponseDoneImpl(1);
        FilterParserImpl l_filter = null;
        ExprNode l_expr = null;
        SearchRequestImpl l_request = new SearchRequestImpl(this.id);
        ++this.id;
        MessageEncoder l_encoder = new MessageEncoder();
        MessageDecoder l_decoder = new MessageDecoder();
        l_filter = new FilterParserImpl();
        try {
            l_expr = l_filter.parse(a_parms.getFilter());
        }
        catch (IOException ioe) {
            System.out.println("IO Error while parsing the filter " + ioe.getMessage());
            System.exit(1);
        }
        catch (ParseException pe) {
            System.out.println("Parsing Exception " + pe.getMessage());
            System.exit(1);
        }
        l_request.setFilter(l_expr);
        l_request.setBase(a_parms.getBase());
        l_request.setScope(a_parms.getScope());
        l_request.setDerefAliases(DerefAliasesEnum.NEVERDEREFALIASES);
        l_request.setTimeLimit(a_parms.getMaxTime());
        l_request.setSizeLimit(a_parms.getMaxEntries());
        l_request.setTypesOnly(a_parms.isTypesMode());
        l_encoder.encodeBlocking(null, this.m_socket.getOutputStream(), (Object)l_request);
        l_response = l_decoder.decode(null, this.m_socket.getInputStream());
        while (!l_response.getClass().isInstance(l_searchResponseDone)) {
            SearchResponseEntryImpl l_searchResponseEntry = (SearchResponseEntryImpl)l_response;
            System.out.println(l_searchResponseEntry.getObjectName());
            if (a_parms.isTypesMode()) {
                this.printAttributeNames(l_searchResponseEntry.getAttributes().getAll());
            } else if (!a_parms.isQuietMode()) {
                this.printAttributeList(l_searchResponseEntry.getAttributes().getAll());
            }
            System.out.println();
            l_response = l_decoder.decode(null, this.m_socket.getInputStream());
        }
        l_searchResponseDone = (SearchResponseDoneImpl)l_response;
        if (l_searchResponseDone.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            System.out.println("Search failed for the following reasons :\n" + new String(l_searchResponseDone.getLdapResult().getErrorMessage()));
            System.exit(-1);
        } else {
            System.out.println("Search with filter " + a_parms.getFilter() + " was successful");
        }
        return l_clientReponse;
    }

    public void printAttributeNames(NamingEnumeration a_attributeList) {
        while (a_attributeList.hasMoreElements()) {
            Attribute l_attr = (Attribute)a_attributeList.nextElement();
            System.out.println(l_attr.getID());
        }
    }

    public void printAttributeList(NamingEnumeration a_attributeList) {
        while (a_attributeList.hasMoreElements()) {
            Attribute l_attr = (Attribute)a_attributeList.nextElement();
            try {
                NamingEnumeration<?> l_attrValues = l_attr.getAll();
                while (l_attrValues.hasMoreElements()) {
                    System.out.print(l_attr.getID() + "=");
                    System.out.println(l_attrValues.nextElement().toString());
                }
            }
            catch (NamingException e) {
                System.out.println("Naming Exception thrown retreiving values for attribute " + l_attr.getID());
            }
        }
    }
}

