/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients.ldaptest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.ldap.clients.ldaptest.LdapTestSession;
import org.apache.ldap.clients.ldaptest.SessionListUI;
import org.apache.ldap.clients.ldaptest.TestCaseListUI;
import org.apache.ldap.clients.ldaptest.TestConfiguration;

public class LdapTester {
    JTextArea output;
    JScrollPane scrollPane;
    TestConfiguration m_config = new TestConfiguration();

    public LdapTester(String a_fileName) {
        this.m_config.readConfig(a_fileName);
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Exit", 88);
        menuItem.addActionListener(new ExitMenuListener());
        menu.add(menuItem);
        menuItem = new JMenuItem("Refresh", 82);
        menuItem.addActionListener(new RefreshOutputListener());
        menu.add(menuItem);
        menu = new JMenu("Window");
        menu.setMnemonic(87);
        menu.getAccessibleContext().setAccessibleDescription("Change Session and Test Cases");
        menuBar.add(menu);
        menuItem = new JMenuItem("Sessions", 83);
        menuItem.addActionListener(new SessionWindowListener());
        menu.add(menuItem);
        menuItem = new JMenuItem("Test Cases", 83);
        menuItem.addActionListener(new TestCaseWindowListener());
        menu.add(menuItem);
        return menuBar;
    }

    public Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        this.output = new JTextArea(5, 30);
        this.output.setEditable(false);
        this.scrollPane = new JScrollPane(this.output);
        contentPane.add((Component)this.scrollPane, "Center");
        return contentPane;
    }

    private static void createAndShowGUI(String a_fileName) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("MenuLookDemo");
        frame.setDefaultCloseOperation(3);
        LdapTester tester = new LdapTester(a_fileName);
        frame.setJMenuBar(tester.createMenuBar());
        frame.setContentPane(tester.createContentPane());
        frame.setSize(450, 260);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: LdapTester config_file_name");
            System.exit(-1);
        }
        final String l_fileName = new String(args[0]);
        System.out.println("Filename is " + l_fileName);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LdapTester.createAndShowGUI(l_fileName);
            }
        });
    }

    class RefreshOutputListener
    implements ActionListener {
        RefreshOutputListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String l_outText = new String();
            l_outText = LdapTester.this.m_config.getSessionCount() + " Sessions \n";
            for (int l_index = 0; l_index < LdapTester.this.m_config.getSessionCount(); ++l_index) {
                LdapTestSession l_session = new LdapTestSession();
                l_session = LdapTester.this.m_config.getSession(l_index);
                l_outText = l_outText + "\t" + l_session.getHost() + "\n";
            }
            LdapTester.this.output.setText(l_outText);
        }
    }

    class ExitMenuListener
    implements ActionListener {
        ExitMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class TestCaseWindowListener
    implements ActionListener {
        TestCaseWindowListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TestCaseListUI l_testCaseWindow = new TestCaseListUI(LdapTester.this.m_config);
        }
    }

    class SessionWindowListener
    implements ActionListener {
        SessionWindowListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SessionListUI l_sessionWindow = new SessionListUI(LdapTester.this.m_config);
        }
    }
}

