/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients.ldaptest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.ldap.clients.ldaptest.LdapTestSession;
import org.apache.ldap.clients.ldaptest.TestConfiguration;

public class SessionAddUI
extends JPanel {
    private JTextField l_sessionNameText;
    private JTextField l_sessionDescrText;
    private JTextField l_hostText;
    private JTextField l_portText;
    private JCheckBox l_annonButton;
    private JTextField l_dnText;
    private JTextField l_passwordText;

    public SessionAddUI(TestConfiguration a_config, DefaultListModel a_list, int a_index) {
        super(new BorderLayout());
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame l_frame = new JFrame("Session Editor");
        l_frame.setDefaultCloseOperation(2);
        l_frame.setResizable(false);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        JPanel l_sessionNamePanel = new JPanel();
        l_sessionNamePanel.setLayout(new BoxLayout(l_sessionNamePanel, 0));
        JLabel l_sessionNameLabel = new JLabel("Session Name: ");
        this.l_sessionNameText = new JTextField(10);
        l_sessionNamePanel.add((Component)l_sessionNameLabel, "West");
        l_sessionNamePanel.add((Component)this.l_sessionNameText, "West");
        l_sessionNamePanel.add(Box.createHorizontalStrut(200));
        JPanel l_sessionDescrPanel = new JPanel();
        JLabel l_sessionDescrLabel = new JLabel();
        l_sessionDescrLabel.setText("Description: ");
        this.l_sessionDescrText = new JTextField(30);
        l_sessionDescrPanel.add((Component)l_sessionDescrLabel, "West");
        l_sessionDescrPanel.add((Component)this.l_sessionDescrText, "West");
        JPanel l_sessionInfoPanel = new JPanel();
        l_sessionInfoPanel.setLayout(new BoxLayout(l_sessionInfoPanel, 1));
        TitledBorder l_sessionInfoTitle = BorderFactory.createTitledBorder(loweredetched, "Session Description");
        l_sessionInfoTitle.setTitleJustification(1);
        l_sessionInfoPanel.setBorder(l_sessionInfoTitle);
        l_sessionInfoPanel.add((Component)l_sessionNamePanel, "West");
        l_sessionInfoPanel.add((Component)l_sessionDescrPanel, "West");
        JLabel l_hostLabel = new JLabel();
        l_hostLabel.setText("Host: ");
        this.l_hostText = new JTextField(7);
        JLabel l_portLabel = new JLabel();
        l_portLabel.setText("Port: ");
        this.l_portText = new JTextField(3);
        JLabel l_annonLabel = new JLabel();
        l_annonLabel.setText("Annonyomous Bind ");
        this.l_annonButton = new JCheckBox();
        JPanel l_connectionInfoPanel = new JPanel();
        l_connectionInfoPanel.setLayout(new BoxLayout(l_connectionInfoPanel, 0));
        TitledBorder l_connectionInfoTitle = BorderFactory.createTitledBorder(loweredetched, "Connection Info");
        l_connectionInfoTitle.setTitleJustification(1);
        l_connectionInfoPanel.setBorder(l_connectionInfoTitle);
        l_connectionInfoPanel.add(l_hostLabel);
        l_connectionInfoPanel.add(this.l_hostText);
        l_connectionInfoPanel.add(Box.createHorizontalStrut(20));
        l_connectionInfoPanel.add(l_portLabel);
        l_connectionInfoPanel.add(this.l_portText);
        l_connectionInfoPanel.add(Box.createHorizontalStrut(20));
        l_connectionInfoPanel.add(l_annonLabel);
        l_connectionInfoPanel.add(this.l_annonButton);
        JLabel l_dnLabel = new JLabel();
        l_dnLabel.setText("Bind DN: ");
        this.l_dnText = new JTextField(10);
        JLabel l_passwordLabel = new JLabel();
        l_passwordLabel.setText("Bind Password: ");
        this.l_passwordText = new JTextField(10);
        JPanel l_bindInfoPanel = new JPanel();
        l_bindInfoPanel.setLayout(new BoxLayout(l_bindInfoPanel, 0));
        TitledBorder l_bindInfoTitle = BorderFactory.createTitledBorder(loweredetched, "Bind Info");
        l_bindInfoTitle.setTitleJustification(1);
        l_bindInfoPanel.setBorder(l_bindInfoTitle);
        l_bindInfoPanel.add(l_dnLabel);
        l_bindInfoPanel.add(this.l_dnText);
        l_bindInfoPanel.add(Box.createHorizontalStrut(20));
        l_bindInfoPanel.add(l_passwordLabel);
        l_bindInfoPanel.add(this.l_passwordText);
        JButton l_addButton = new JButton();
        if (a_index < 0) {
            l_addButton.setText("Add");
            l_addButton.addActionListener(new AddListener(a_config, a_list));
        } else {
            l_addButton.setText("Modify");
            l_addButton.addActionListener(new ModifyListener(a_config, a_list, a_index));
            this.l_sessionNameText.setText(a_config.getSession(a_index).getSessionName());
            this.l_sessionDescrText.setText(a_config.getSession(a_index).getSessionDescription());
            this.l_hostText.setText(a_config.getSession(a_index).getHost());
            this.l_portText.setText(Integer.toString(a_config.getSession(a_index).getPort()));
            this.l_annonButton.setSelected(a_config.getSession(a_index).isAnnonBind());
            this.l_dnText.setText(a_config.getSession(a_index).getBindDn());
            this.l_passwordText.setText(a_config.getSession(a_index).getBindPassword());
        }
        JButton l_cancelButton = new JButton();
        l_cancelButton.setText("Cancel");
        l_cancelButton.addActionListener(new CancelListener(l_frame));
        JPanel l_buttonPanel = new JPanel();
        l_buttonPanel.add(l_addButton);
        l_buttonPanel.add(Box.createHorizontalStrut(20));
        l_buttonPanel.add(l_cancelButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)l_sessionInfoPanel, "East");
        this.add(Box.createVerticalStrut(8));
        this.add(l_connectionInfoPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(l_bindInfoPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(l_buttonPanel);
        l_frame.setContentPane(this);
        l_frame.pack();
        l_frame.setVisible(true);
    }

    public boolean verifyInput(TestConfiguration a_config) {
        int l_port;
        if (this.l_sessionNameText.getText().equalsIgnoreCase("")) {
            System.out.println("Name is a required Field");
            this.l_sessionNameText.requestFocusInWindow();
            return false;
        }
        if (this.l_hostText.getText().equalsIgnoreCase("")) {
            System.out.println("Host is a required Field");
            this.l_hostText.requestFocusInWindow();
            return false;
        }
        if (!this.l_annonButton.isSelected() && this.l_dnText.getText().equalsIgnoreCase("")) {
            System.out.println("DN is required");
            this.l_dnText.requestFocusInWindow();
            return false;
        }
        if (!this.l_annonButton.isSelected() && this.l_passwordText.getText().equalsIgnoreCase("")) {
            System.out.println("Password is a required Field");
            this.l_passwordText.requestFocusInWindow();
            return false;
        }
        String l_text = new String(this.l_sessionNameText.getText());
        for (int l_index = 0; l_index < a_config.getSessionCount(); ++l_index) {
            if (!a_config.getSession(l_index).getSessionName().equalsIgnoreCase(l_text)) continue;
            System.out.println(l_text + " Already exists");
            this.l_sessionNameText.requestFocusInWindow();
            return false;
        }
        try {
            l_port = Integer.parseInt(this.l_portText.getText());
        }
        catch (NumberFormatException nfe) {
            l_port = 0;
        }
        if (l_port < 1 || l_port > 99999) {
            System.out.println(this.l_portText.getText() + " is an invalid port");
            this.l_sessionNameText.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public LdapTestSession parseFields() {
        LdapTestSession l_session = new LdapTestSession();
        l_session.setSessionName(this.l_sessionNameText.getText());
        l_session.setSessionDescription(this.l_sessionDescrText.getText());
        l_session.setHost(this.l_hostText.getText());
        l_session.setPort(Integer.parseInt(this.l_portText.getText()));
        if (!this.l_annonButton.isSelected()) {
            l_session.setBindDn(this.l_dnText.getText());
            l_session.setBindPassword(this.l_passwordText.getText());
        }
        this.l_sessionNameText.setText("");
        this.l_sessionDescrText.setText("");
        this.l_hostText.setText("");
        this.l_portText.setText("");
        this.l_dnText.setText("");
        this.l_passwordText.setText("");
        return l_session;
    }

    class CancelListener
    implements ActionListener {
        JFrame l_frame;

        public CancelListener(JFrame a_frame) {
            this.l_frame = a_frame;
        }

        public void actionPerformed(ActionEvent e) {
            this.l_frame.dispose();
        }
    }

    class ModifyListener
    implements ActionListener {
        private TestConfiguration l_config;
        private DefaultListModel l_list;
        private int l_listIndex;

        public ModifyListener(TestConfiguration a_config, DefaultListModel a_list, int a_index) {
            this.l_config = a_config;
            this.l_list = a_list;
            this.l_listIndex = a_index;
        }

        public void actionPerformed(ActionEvent e) {
            LdapTestSession l_oldSession = this.l_config.getSession(this.l_listIndex);
            String l_oldEntry = (String)this.l_list.getElementAt(this.l_listIndex);
            this.l_config.removeSession(this.l_listIndex);
            this.l_list.removeElementAt(this.l_listIndex);
            if (SessionAddUI.this.verifyInput(this.l_config)) {
                String l_entry = new String();
                LdapTestSession l_newSession = SessionAddUI.this.parseFields();
                l_entry = l_newSession.getSessionName() + " - " + l_newSession.getSessionDescription();
                this.l_list.add(this.l_listIndex, l_entry);
                this.l_config.addSession(this.l_listIndex, l_newSession);
            } else {
                this.l_list.add(this.l_listIndex, l_oldEntry);
                this.l_config.addSession(this.l_listIndex, l_oldSession);
            }
        }
    }

    class AddListener
    implements ActionListener {
        TestConfiguration l_config;
        DefaultListModel l_list;

        public AddListener(TestConfiguration a_config, DefaultListModel a_list) {
            this.l_config = a_config;
            this.l_list = a_list;
        }

        public void actionPerformed(ActionEvent e) {
            if (SessionAddUI.this.verifyInput(this.l_config)) {
                String l_entry = new String();
                LdapTestSession l_session = SessionAddUI.this.parseFields();
                l_entry = l_session.getSessionName() + " - " + l_session.getSessionDescription();
                this.l_list.addElement(l_entry);
                this.l_config.addSession(l_session);
            }
        }
    }
}

