/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients.ldaptest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.ldap.clients.ldaptest.LdapTestSession;
import org.apache.ldap.clients.ldaptest.SessionAddUI;
import org.apache.ldap.clients.ldaptest.TestConfiguration;

public class SessionListUI
extends JPanel {
    private JList list;
    private DefaultListModel listModel;
    private static final String addString = " Add  ";
    private static final String deleteString = "Delete";
    private static final String modifyString = "Modify";
    private static final String cancelString = "Cancel";

    public SessionListUI(TestConfiguration a_config) {
        super(new BorderLayout());
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("Session Management");
        frame.setDefaultCloseOperation(2);
        this.listModel = new DefaultListModel();
        for (int l_index = 0; l_index < a_config.getSessionCount(); ++l_index) {
            String l_listEntry = new String();
            l_listEntry = a_config.getSession(l_index).getSessionName() + " - " + a_config.getSession(l_index).getSessionDescription();
            this.listModel.addElement(l_listEntry);
        }
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.setVisibleRowCount(10);
        this.list.setPreferredSize(new Dimension(400, 600));
        JScrollPane listScrollPane = new JScrollPane(this.list);
        JButton addButton = new JButton(addString);
        addButton.setActionCommand(addString);
        addButton.addActionListener(new AddListener(a_config));
        JButton deleteButton = new JButton(deleteString);
        deleteButton.setActionCommand(deleteString);
        deleteButton.addActionListener(new DeleteListener(a_config));
        JButton modifyButton = new JButton(modifyString);
        modifyButton.setActionCommand(modifyString);
        modifyButton.addActionListener(new ModifyListener(a_config));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.add(deleteButton);
        buttonPane.add(Box.createVerticalStrut(8));
        buttonPane.add(addButton);
        buttonPane.add(Box.createVerticalStrut(8));
        buttonPane.add(modifyButton);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)buttonPane, "East");
        this.add((Component)listScrollPane, "Center");
        frame.setContentPane(this);
        frame.pack();
        frame.setVisible(true);
    }

    class ModifyListener
    implements ActionListener {
        TestConfiguration l_config;

        public ModifyListener(TestConfiguration a_config) {
            this.l_config = a_config;
        }

        public void actionPerformed(ActionEvent e) {
            SessionAddUI l_addUI = new SessionAddUI(this.l_config, SessionListUI.this.listModel, SessionListUI.this.list.getSelectedIndex());
        }
    }

    class AddListener
    implements ActionListener {
        TestConfiguration l_config;

        public AddListener(TestConfiguration a_config) {
            this.l_config = a_config;
        }

        public void actionPerformed(ActionEvent e) {
            SessionAddUI l_addUI = new SessionAddUI(this.l_config, SessionListUI.this.listModel, -1);
        }
    }

    class DeleteListener
    implements ActionListener {
        TestConfiguration l_config;

        public DeleteListener(TestConfiguration a_config) {
            this.l_config = a_config;
        }

        public void actionPerformed(ActionEvent e) {
            int l_index = SessionListUI.this.list.getSelectedIndex();
            String l_string = (String)SessionListUI.this.list.getSelectedValue();
            l_string = l_string.substring(0, l_string.indexOf(45)).trim();
            LdapTestSession l_session = this.l_config.getSession(l_index);
            if (!l_session.getSessionName().equalsIgnoreCase(l_string)) {
                System.out.println("Mismatch, reload config");
                System.out.println("List: /" + l_string + "/");
                System.out.println("Sess: /" + l_session.getSessionName() + "/");
            } else {
                this.l_config.removeSession(l_index);
                SessionListUI.this.listModel.remove(l_index);
            }
        }
    }
}

