/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.clients.ldaptest;

import java.io.IOException;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ldap.clients.ldaptest.LdapTestCase;
import org.apache.ldap.clients.ldaptest.LdapTestSession;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TestConfiguration {
    private LinkedList sessions = new LinkedList();
    private LinkedList testCases = new LinkedList();

    private LdapTestSession getSessionConfig(Node node) {
        LdapTestSession session = new LdapTestSession();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if (name.equalsIgnoreCase("host")) {
                session.setHost(child.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equalsIgnoreCase("port")) {
                session.setPort(Integer.parseInt(child.getFirstChild().getNodeValue()));
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                session.setSessionName(child.getFirstChild().getNodeValue());
                continue;
            }
            if (!name.equalsIgnoreCase("descr")) continue;
            session.setSessionDescription(child.getFirstChild().getNodeValue());
        }
        return session;
    }

    private LdapTestCase getTestCaseConfig(Node node) {
        LdapTestCase testCase = new LdapTestCase();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if (name.equalsIgnoreCase("entry")) {
                testCase.setArgs(child.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equalsIgnoreCase("operation")) {
                testCase.setOperation(Integer.parseInt(child.getFirstChild().getNodeValue()));
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                testCase.setTestCaseName(child.getFirstChild().getNodeValue());
                continue;
            }
            if (!name.equalsIgnoreCase("descr")) continue;
            testCase.setTestCaseDescription(child.getFirstChild().getNodeValue());
        }
        return testCase;
    }

    public void readConfig(String fileName) {
        String name;
        Node child;
        Node document = null;
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
            document = builder.parse(fileName);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        for (child = document.getFirstChild(); !(child == null || (name = child.getNodeName()).equalsIgnoreCase("LdapTester") && child.hasChildNodes()); child = child.getNextSibling()) {
        }
        for (child = child.getFirstChild(); child != null; child = child.getNextSibling()) {
            name = child.getNodeName();
            if (name.equalsIgnoreCase("session")) {
                this.sessions.add(this.getSessionConfig(child));
                continue;
            }
            if (!name.equalsIgnoreCase("testcase")) continue;
            this.testCases.add(this.getTestCaseConfig(child));
        }
    }

    public int getSessionCount() {
        return this.sessions.size();
    }

    public LdapTestSession getSession(int index) {
        return (LdapTestSession)this.sessions.get(index);
    }

    public void addSession(LdapTestSession session) {
        this.sessions.add(session);
    }

    public void addSession(int index, LdapTestSession session) {
        this.sessions.add(index, session);
    }

    public void removeSession(int index) {
        this.sessions.remove(index);
    }

    public int getTestCaseCount() {
        return this.testCases.size();
    }

    public LdapTestCase getTestCase(int index) {
        return (LdapTestCase)this.testCases.get(index);
    }

    public void addTestCase(LdapTestCase session) {
        this.testCases.add(session);
    }

    public void addTestCase(int index, LdapTestCase session) {
        this.testCases.add(index, session);
    }

    public void removeTestCase(int index) {
        this.testCases.remove(index);
    }
}

