/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1;

import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.message.AbandonRequestImpl;
import org.apache.ldap.common.message.AddRequestImpl;
import org.apache.ldap.common.message.AddResponseImpl;
import org.apache.ldap.common.message.BindRequestImpl;
import org.apache.ldap.common.message.BindResponseImpl;
import org.apache.ldap.common.message.CompareRequestImpl;
import org.apache.ldap.common.message.CompareResponseImpl;
import org.apache.ldap.common.message.DeleteRequestImpl;
import org.apache.ldap.common.message.DeleteResponseImpl;
import org.apache.ldap.common.message.ExtendedRequestImpl;
import org.apache.ldap.common.message.ExtendedResponseImpl;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ModifyDnRequestImpl;
import org.apache.ldap.common.message.ModifyDnResponseImpl;
import org.apache.ldap.common.message.ModifyRequestImpl;
import org.apache.ldap.common.message.ModifyResponseImpl;
import org.apache.ldap.common.message.SearchRequestImpl;
import org.apache.ldap.common.message.SearchResponseDoneImpl;
import org.apache.ldap.common.message.SearchResponseEntryImpl;
import org.apache.ldap.common.message.SearchResponseReferenceImpl;
import org.apache.ldap.common.message.UnbindRequestImpl;

public final class LdapMessageFactory {
    public static final Message create(LdapTag tag, int messageId) {
        return LdapMessageFactory.create(tag.getTagId(), messageId);
    }

    public static final Message create(int tagId, int messageId) {
        BindRequestImpl pdu = null;
        switch (tagId) {
            case 0: {
                pdu = new BindRequestImpl(messageId);
                break;
            }
            case 1: {
                pdu = new BindResponseImpl(messageId);
                break;
            }
            case 2: {
                pdu = new UnbindRequestImpl(messageId);
                break;
            }
            case 3: {
                pdu = new SearchRequestImpl(messageId);
                break;
            }
            case 4: {
                pdu = new SearchResponseEntryImpl(messageId);
                break;
            }
            case 5: {
                pdu = new SearchResponseDoneImpl(messageId);
                break;
            }
            case 19: {
                pdu = new SearchResponseReferenceImpl(messageId);
                break;
            }
            case 6: {
                pdu = new ModifyRequestImpl(messageId);
                break;
            }
            case 7: {
                pdu = new ModifyResponseImpl(messageId);
                break;
            }
            case 8: {
                pdu = new AddRequestImpl(messageId);
                break;
            }
            case 9: {
                pdu = new AddResponseImpl(messageId);
                break;
            }
            case 10: {
                pdu = new DeleteRequestImpl(messageId);
                break;
            }
            case 11: {
                pdu = new DeleteResponseImpl(messageId);
                break;
            }
            case 12: {
                pdu = new ModifyDnRequestImpl(messageId);
                break;
            }
            case 13: {
                pdu = new ModifyDnResponseImpl(messageId);
                break;
            }
            case 14: {
                pdu = new CompareRequestImpl(messageId);
                break;
            }
            case 15: {
                pdu = new CompareResponseImpl(messageId);
                break;
            }
            case 16: {
                pdu = new AbandonRequestImpl(messageId);
                break;
            }
            case 23: {
                pdu = new ExtendedRequestImpl(messageId);
                break;
            }
            case 24: {
                pdu = new ExtendedResponseImpl(messageId);
                break;
            }
            default: {
                throw new IllegalStateException("shouldn't happen - if it does then we have issues");
            }
        }
        return pdu;
    }
}

