/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.rules.PrimitiveOctetStringRule;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchRequestProcessing;
import org.apache.ldap.common.filter.SimpleNode;

public class EqualityMatchRule
extends PrimitiveOctetStringRule {
    private boolean isEnabled = true;
    private String name = null;
    private String value = null;

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        int tagCount = this.getDigester().getTagCount();
        if (tagCount < 4) {
            this.isEnabled = false;
            return;
        }
        if (this.getDigester().getTag(tagCount - 2) != LdapTag.SEARCH_REQUEST.getPrimitiveTag()) {
            this.isEnabled = false;
            return;
        }
        super.tag(id, isPrimitive, typeClass);
        int ii = this.getDigester().getCount() - 2;
        SearchRequestProcessing processing = (SearchRequestProcessing)this.getDigester().peek(ii);
        if (processing.getState() != processing.FILTER_STATE) {
            this.isEnabled = false;
        }
    }

    public void length(int length) {
        if (this.isEnabled) {
            super.length(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.isEnabled) {
            super.value(buf);
        }
    }

    public void finish() {
        if (!this.isEnabled) {
            this.isEnabled = true;
            return;
        }
        super.finish();
        ByteBuffer buf = (ByteBuffer)this.getDigester().pop();
        byte[] octets = null;
        if (buf.limit() == buf.capacity() && buf.hasArray()) {
            octets = buf.array();
        } else {
            octets = new byte[buf.remaining()];
            buf.get(octets);
        }
        if (this.name == null && this.value == null) {
            this.name = new String(octets);
        } else if (this.name != null && this.value == null) {
            this.value = new String(octets);
            SimpleNode node = new SimpleNode(this.name, this.value, 0);
            this.getDigester().push((Object)node);
            this.name = null;
            this.value = null;
        } else {
            throw new IllegalStateException("name = " + this.name + " and value = " + this.value);
        }
    }
}

