/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.primitives.PrimitiveUtils;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.decoder.search.BaseSearchRequestRule;

public class SizeLimitRule
extends BaseSearchRequestRule {
    private final byte[] value = new byte[4];
    private int pos;
    private int length;

    public SizeLimitRule() {
        super(3);
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        super.tag(id, isPrimitive, typeClass);
        if (this.getDigester().getTopTag() != UniversalTag.INTEGER.getPrimitiveTag()) {
            this.setEnabled(false);
        }
        if (this.getProcessing().getState() != this.getProcessing().SIZE_LIMIT_STATE) {
            this.setEnabled(false);
        }
    }

    public void length(int length) {
        if (!this.isEnabled()) {
            return;
        }
        if (length > 4 || length < 0) {
            throw new IllegalArgumentException("The target primitive for this rule can only hold integers of 32 bits or 4 bytes.  The length of the field however is " + length);
        }
        this.length = length;
    }

    public void value(ByteBuffer buf) {
        if (!this.isEnabled()) {
            return;
        }
        if (buf == null) {
            return;
        }
        while (buf.hasRemaining() && this.pos + 1 <= this.length) {
            this.value[this.pos] = buf.get();
            ++this.pos;
        }
    }

    public void finish() {
        if (!this.isEnabled()) {
            this.pos = 0;
            this.length = 0;
            super.finish();
            return;
        }
        int numba = PrimitiveUtils.decodeInt((byte[])this.value, (int)0, (int)this.length);
        this.getRequest().setSizeLimit(numba);
        this.pos = 0;
        this.length = 0;
        super.finish();
    }
}

