/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.crypto.encryption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CipherType
implements Comparable {
    public static final CipherType NULL = new CipherType("null");
    public static final CipherType DES = new CipherType("DES");
    public static final CipherType DES3 = new CipherType("DES3");
    public static final CipherType AES128 = new CipherType("AES128");
    private final String fName;
    private static int fNextOrdinal = 0;
    private final int fOrdinal = fNextOrdinal++;
    private static final CipherType[] fValues = new CipherType[]{NULL, DES, DES3, AES128};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(fValues));

    public String toString() {
        return this.fName;
    }

    public int compareTo(Object that) {
        return this.fOrdinal - ((CipherType)that).fOrdinal;
    }

    public CipherType getTypeByOrdinal(int type) {
        for (int i = 0; i < fValues.length; ++i) {
            if (CipherType.fValues[i].fOrdinal != type) continue;
            return fValues[i];
        }
        return NULL;
    }

    private CipherType(String aName) {
        this.fName = aName;
    }
}

