/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.util.Enumeration;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.crypto.checksum.ChecksumType;
import org.apache.kerberos.messages.value.Checksum;

public class ChecksumDecoder {
    public static Checksum decode(DERSequence sequence) {
        ChecksumType type = ChecksumType.NULL;
        byte[] data = null;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    type = ChecksumType.getTypeByOrdinal(tag0.intValue());
                    break;
                }
                case 1: {
                    DEROctetString tag1 = (DEROctetString)derObject;
                    data = tag1.getOctets();
                }
            }
        }
        return new Checksum(type, data);
    }
}

