/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERGeneralString;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;

public class PrincipalNameEncoder {
    private static final String COMPONENT_SEPARATOR = "/";
    private static final String REALM_SEPARATOR = "@";

    protected static DERSequence encode(KerberosPrincipal principal) {
        DERSequence vector = new DERSequence();
        vector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)principal.getNameType())));
        vector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)PrincipalNameEncoder.encodeNameSequence(principal)));
        return vector;
    }

    private static DERSequence encodeNameSequence(KerberosPrincipal principal) {
        Iterator it = PrincipalNameEncoder.getNameStrings(principal).iterator();
        DERSequence vector = new DERSequence();
        while (it.hasNext()) {
            vector.add((DEREncodable)DERGeneralString.valueOf((String)((String)it.next())));
        }
        return vector;
    }

    private static List getNameStrings(KerberosPrincipal principal) {
        String nameComponent = principal.getName().split(REALM_SEPARATOR)[0];
        String[] components = nameComponent.split(COMPONENT_SEPARATOR);
        return Arrays.asList(components);
    }
}

