/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.messages.components.MessageComponentType;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.HostAddresses;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.LastRequest;
import org.apache.kerberos.messages.value.TicketFlags;

public class EncKdcRepPart {
    private EncryptionKey _key;
    private LastRequest _lastRequest;
    private int _nonce;
    private KerberosTime _keyExpiration;
    private TicketFlags _flags = new TicketFlags();
    private KerberosTime _authTime;
    private KerberosTime _startTime;
    private KerberosTime _endTime;
    private KerberosTime _renewTill;
    private KerberosPrincipal _serverPrincipal;
    private HostAddresses _clientAddresses;
    private MessageComponentType _componentType;

    public EncKdcRepPart() {
    }

    public EncKdcRepPart(EncryptionKey key, LastRequest lastReq, int nonce, KerberosTime keyExpiration, TicketFlags flags, KerberosTime authtime, KerberosTime starttime, KerberosTime endtime, KerberosTime renewTill, KerberosPrincipal serverPrincipal, HostAddresses caddr, MessageComponentType componentType) {
        this._key = key;
        this._lastRequest = lastReq;
        this._nonce = nonce;
        this._keyExpiration = keyExpiration;
        this._flags = flags;
        this._authTime = authtime;
        this._startTime = starttime;
        this._endTime = endtime;
        this._renewTill = renewTill;
        this._serverPrincipal = serverPrincipal;
        this._clientAddresses = caddr;
        this._componentType = componentType;
    }

    public KerberosTime getAuthTime() {
        return this._authTime;
    }

    public HostAddresses getClientAddresses() {
        return this._clientAddresses;
    }

    public KerberosTime getEndTime() {
        return this._endTime;
    }

    public TicketFlags getFlags() {
        return this._flags;
    }

    public EncryptionKey getKey() {
        return this._key;
    }

    public KerberosTime getKeyExpiration() {
        return this._keyExpiration;
    }

    public LastRequest getLastRequest() {
        return this._lastRequest;
    }

    public int getNonce() {
        return this._nonce;
    }

    public KerberosTime getRenewTill() {
        return this._renewTill;
    }

    public KerberosPrincipal getServerPrincipal() {
        return this._serverPrincipal;
    }

    public String getServerRealm() {
        return this._serverPrincipal.getRealm();
    }

    public KerberosTime getStartTime() {
        return this._startTime;
    }

    public MessageComponentType getComponentType() {
        return this._componentType;
    }

    public void setAuthTime(KerberosTime time) {
        this._authTime = time;
    }

    public void setClientAddresses(HostAddresses addresses) {
        this._clientAddresses = addresses;
    }

    public void setEndTime(KerberosTime time) {
        this._endTime = time;
    }

    public void setFlags(TicketFlags flags) {
        this._flags = flags;
    }

    public void setKey(EncryptionKey key) {
        this._key = key;
    }

    public void setKeyExpiration(KerberosTime expiration) {
        this._keyExpiration = expiration;
    }

    public void setLastRequest(LastRequest request) {
        this._lastRequest = request;
    }

    public void setNonce(int nonce) {
        this._nonce = nonce;
    }

    public void setRenewTill(KerberosTime till) {
        this._renewTill = till;
    }

    public void setServerPrincipal(KerberosPrincipal principal) {
        this._serverPrincipal = principal;
    }

    public void setStartTime(KerberosTime time) {
        this._startTime = time;
    }
}

