/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.messages.components.EncTicketPart;
import org.apache.kerberos.messages.value.AuthorizationData;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.HostAddresses;
import org.apache.kerberos.messages.value.KerberosPrincipalModifier;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.PrincipalName;
import org.apache.kerberos.messages.value.TicketFlags;
import org.apache.kerberos.messages.value.TransitedEncoding;

public class EncTicketPartModifier {
    private TicketFlags _flags = new TicketFlags();
    private EncryptionKey _sessionKey;
    private KerberosPrincipalModifier _modifier = new KerberosPrincipalModifier();
    private KerberosPrincipal _clientPrincipal;
    private TransitedEncoding _transitedEncoding;
    private KerberosTime _authTime;
    private KerberosTime _startTime;
    private KerberosTime _endTime;
    private KerberosTime _renewTill;
    private HostAddresses _clientAddresses;
    private AuthorizationData _authorizationData;

    public EncTicketPart getEncTicketPart() {
        if (this._clientPrincipal == null) {
            this._clientPrincipal = this._modifier.getKerberosPrincipal();
        }
        return new EncTicketPart(this._flags, this._sessionKey, this._clientPrincipal, this._transitedEncoding, this._authTime, this._startTime, this._endTime, this._renewTill, this._clientAddresses, this._authorizationData);
    }

    public void setClientName(PrincipalName name) {
        this._modifier.setPrincipalName(name);
    }

    public void setClientRealm(String realm) {
        this._modifier.setRealm(realm);
    }

    public void setClientPrincipal(KerberosPrincipal principal) {
        this._clientPrincipal = principal;
    }

    public void setAuthorizationData(AuthorizationData data) {
        this._authorizationData = data;
    }

    public void setAuthTime(KerberosTime authtime) {
        this._authTime = authtime;
    }

    public void setClientAddresses(HostAddresses addresses) {
        this._clientAddresses = addresses;
    }

    public void setEndTime(KerberosTime time) {
        this._endTime = time;
    }

    public void setFlags(TicketFlags flags) {
        this._flags = flags;
    }

    public void setFlag(int flag) {
        this._flags.set(flag);
    }

    public void clearFlag(int flag) {
        this._flags.clear(flag);
    }

    public void setRenewTill(KerberosTime till) {
        this._renewTill = till;
    }

    public void setSessionKey(EncryptionKey key) {
        this._sessionKey = key;
    }

    public void setStartTime(KerberosTime time) {
        this._startTime = time;
    }

    public void setTransitedEncoding(TransitedEncoding encoding) {
        this._transitedEncoding = encoding;
    }
}

