/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.value;

import java.util.Arrays;
import org.apache.kerberos.crypto.encryption.EncryptionType;

public class EncryptionKey {
    private EncryptionType _keyType;
    private byte[] _keyValue;
    private int _keyVersion;

    public EncryptionKey(EncryptionType keyType, byte[] keyValue) {
        this._keyType = keyType;
        this._keyValue = keyValue;
    }

    public EncryptionKey(EncryptionType keyType, byte[] keyValue, int keyVersion) {
        this._keyType = keyType;
        this._keyValue = keyValue;
        this._keyVersion = keyVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey that = (EncryptionKey)o;
        return this._keyType == that._keyType && Arrays.equals(this._keyValue, that._keyValue);
    }

    public synchronized void destroy() {
        if (this._keyValue != null) {
            for (int i = 0; i < this._keyValue.length; ++i) {
                this._keyValue[i] = 0;
            }
        }
    }

    public String toString() {
        return this._keyType.toString() + " (" + this._keyType.getOrdinal() + ")";
    }

    public EncryptionType getKeyType() {
        return this._keyType;
    }

    public byte[] getKeyValue() {
        return this._keyValue;
    }

    public int getKeyVersion() {
        return this._keyVersion;
    }
}

