/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class HostAddressType
implements Comparable {
    public static final HostAddressType NULL = new HostAddressType(0, "null");
    public static final HostAddressType ADDRTYPE_UNIX = new HostAddressType(1, "Unix");
    public static final HostAddressType ADDRTYPE_INET = new HostAddressType(2, "Internet");
    public static final HostAddressType ADDRTYPE_IMPLINK = new HostAddressType(3, "Arpanet");
    public static final HostAddressType ADDRTYPE_PUP = new HostAddressType(4, "PUP");
    public static final HostAddressType ADDRTYPE_CHAOS = new HostAddressType(5, "CHAOS");
    public static final HostAddressType ADDRTYPE_XNS = new HostAddressType(6, "XEROX Network Services");
    public static final HostAddressType ADDRTYPE_IPX = new HostAddressType(6, "IPX");
    public static final HostAddressType ADDRTYPE_OSI = new HostAddressType(7, "OSI");
    public static final HostAddressType ADDRTYPE_ECMA = new HostAddressType(8, "European Computer Manufacturers");
    public static final HostAddressType ADDRTYPE_DATAKIT = new HostAddressType(9, "Datakit");
    public static final HostAddressType ADDRTYPE_CCITT = new HostAddressType(10, "CCITT");
    public static final HostAddressType ADDRTYPE_SNA = new HostAddressType(11, "SNA");
    public static final HostAddressType ADDRTYPE_DECNET = new HostAddressType(12, "DECnet");
    public static final HostAddressType ADDRTYPE_DLI = new HostAddressType(13, "Direct Data Link Interface");
    public static final HostAddressType ADDRTYPE_LAT = new HostAddressType(14, "LAT");
    public static final HostAddressType ADDRTYPE_HYLINK = new HostAddressType(15, "NSC Hyperchannel");
    public static final HostAddressType ADDRTYPE_APPLETALK = new HostAddressType(16, "AppleTalk");
    public static final HostAddressType ADDRTYPE_NETBIOS = new HostAddressType(17, "NetBios");
    public static final HostAddressType ADDRTYPE_VOICEVIEW = new HostAddressType(18, "VoiceView");
    public static final HostAddressType ADDRTYPE_FIREFOX = new HostAddressType(19, "Firefox");
    public static final HostAddressType ADDRTYPE_BAN = new HostAddressType(21, "Banyan");
    public static final HostAddressType ADDRTYPE_ATM = new HostAddressType(22, "ATM");
    public static final HostAddressType ADDRTYPE_INET6 = new HostAddressType(23, "Internet Protocol V6");
    private final String _fName;
    private final int _fOrdinal;
    private static final HostAddressType[] fValues = new HostAddressType[]{NULL, ADDRTYPE_UNIX, ADDRTYPE_INET, ADDRTYPE_IMPLINK, ADDRTYPE_PUP, ADDRTYPE_CHAOS, ADDRTYPE_XNS, ADDRTYPE_IPX, ADDRTYPE_OSI, ADDRTYPE_ECMA, ADDRTYPE_DATAKIT, ADDRTYPE_CCITT, ADDRTYPE_SNA, ADDRTYPE_DECNET, ADDRTYPE_DLI, ADDRTYPE_LAT, ADDRTYPE_HYLINK, ADDRTYPE_APPLETALK, ADDRTYPE_NETBIOS, ADDRTYPE_VOICEVIEW, ADDRTYPE_FIREFOX, ADDRTYPE_BAN, ADDRTYPE_ATM, ADDRTYPE_INET6};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(fValues));

    public String toString() {
        return this._fName + " (" + this._fOrdinal + ")";
    }

    public int compareTo(Object that) {
        return this._fOrdinal - ((HostAddressType)that)._fOrdinal;
    }

    public static HostAddressType getTypeByOrdinal(int type) {
        for (int i = 0; i < fValues.length; ++i) {
            if (HostAddressType.fValues[i]._fOrdinal != type) continue;
            return fValues[i];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this._fOrdinal;
    }

    private HostAddressType(int ordinal, String name) {
        this._fOrdinal = ordinal;
        this._fName = name;
    }
}

