/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.value;

import java.util.BitSet;

public abstract class Options {
    private BitSet _options;
    private int _maxSize;

    protected Options(int maxSize) {
        this._maxSize = maxSize;
        this._options = new BitSet(this._maxSize);
    }

    public boolean match(Options options, int option) {
        return options.get(option) == this.get(option);
    }

    public boolean get(int index) {
        return this._options.get(index);
    }

    public void set(int index) {
        this._options.set(index);
    }

    public void clear(int index) {
        this._options.clear(index);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this._maxSize / 8];
        for (int i = 0; i < this._maxSize; ++i) {
            if (!this._options.get(this.reversePosition(i))) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    protected void setBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            this._options.set(this.reversePosition(i));
        }
    }

    private int reversePosition(int position) {
        return this._maxSize - 1 - position;
    }
}

