/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.value;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.messages.components.Ticket;
import org.apache.kerberos.messages.value.EncryptedData;
import org.apache.kerberos.messages.value.HostAddresses;
import org.apache.kerberos.messages.value.KdcOptions;
import org.apache.kerberos.messages.value.KerberosPrincipalModifier;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.PrincipalName;
import org.apache.kerberos.messages.value.RequestBody;

public class RequestBodyModifier {
    private KerberosPrincipalModifier _clientModifier = new KerberosPrincipalModifier();
    private KerberosPrincipalModifier _serverModifier = new KerberosPrincipalModifier();
    private KdcOptions _kdcOptions;
    private KerberosTime _from;
    private KerberosTime _till;
    private KerberosTime _rtime;
    private int _nonce;
    private EncryptionType[] _eType;
    private HostAddresses _addresses;
    private EncryptedData _encAuthorizationData;
    private Ticket[] _additionalTickets;

    public RequestBody getRequestBody() {
        KerberosPrincipal clientPrincipal = this._clientModifier.getKerberosPrincipal();
        KerberosPrincipal serverPrincipal = this._serverModifier.getKerberosPrincipal();
        return new RequestBody(this._kdcOptions, clientPrincipal, serverPrincipal, this._from, this._till, this._rtime, this._nonce, this._eType, this._addresses, this._encAuthorizationData, this._additionalTickets);
    }

    public void setClientName(PrincipalName clientName) {
        this._clientModifier.setPrincipalName(clientName);
    }

    public void setServerName(PrincipalName serverName) {
        this._serverModifier.setPrincipalName(serverName);
    }

    public void setRealm(String realm) {
        this._clientModifier.setRealm(realm);
        this._serverModifier.setRealm(realm);
    }

    public void setAdditionalTickets(Ticket[] tickets) {
        this._additionalTickets = tickets;
    }

    public void setAddresses(HostAddresses addresses) {
        this._addresses = addresses;
    }

    public void setEncAuthorizationData(EncryptedData authorizationData) {
        this._encAuthorizationData = authorizationData;
    }

    public void setEType(EncryptionType[] type) {
        this._eType = type;
    }

    public void setFrom(KerberosTime from) {
        this._from = from;
    }

    public void setKdcOptions(KdcOptions options) {
        this._kdcOptions = options;
    }

    public void setNonce(int nonce) {
        this._nonce = nonce;
    }

    public void setRtime(KerberosTime rtime) {
        this._rtime = rtime;
    }

    public void setTill(KerberosTime till) {
        this._till = till;
    }
}

