/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import org.apache.ldap.common.berlib.snacc.ControlTransform;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ModifyDNRequest;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ModifyDnRequest;
import org.apache.ldap.common.message.ModifyDnRequestImpl;
import org.apache.ldap.common.message.spi.ProviderException;

public class ModifyDnRequestTransform {
    static ModifyDnRequest transformFromSnacc(LDAPMessage a_snaccMessage) throws ProviderException {
        ModifyDnRequestImpl l_request = new ModifyDnRequestImpl(a_snaccMessage.messageID.intValue());
        ControlTransform.transformFromSnacc((Message)l_request, a_snaccMessage.controls);
        LDAPMessageChoice l_protocolOp = a_snaccMessage.protocolOp;
        ModifyDNRequest l_snaccRequest = l_protocolOp.modDNRequest;
        l_request.setName(new String(l_snaccRequest.entry));
        l_request.setDeleteOldRdn(l_snaccRequest.deleteoldrdn);
        l_request.setNewRdn(new String(l_snaccRequest.newrdn));
        if (l_snaccRequest.newSuperior != null) {
            l_request.setNewSuperior(new String(l_snaccRequest.newSuperior));
        }
        return l_request;
    }

    static LDAPMessage transformToSnacc(ModifyDnRequest a_request) throws ProviderException {
        ModifyDNRequest l_snaccRequest;
        LDAPMessage l_snaccMessage = Utils.prepareEnvelope((Message)a_request);
        LDAPMessageChoice l_protocolOp = l_snaccMessage.protocolOp;
        l_protocolOp.modDNRequest = l_snaccRequest = new ModifyDNRequest();
        l_protocolOp.choiceId = 0x4000000C;
        l_snaccRequest.entry = a_request.getName().getBytes();
        l_snaccRequest.deleteoldrdn = a_request.getDeleteOldRdn();
        l_snaccRequest.newrdn = a_request.getNewRdn().getBytes();
        if (a_request.isMove()) {
            l_snaccRequest.newSuperior = a_request.getNewSuperior().getBytes();
        }
        return l_snaccMessage;
    }
}

