/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.berlib.snacc.ControlTransform;
import org.apache.ldap.common.berlib.snacc.SnaccProvider;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeTypeAndValues;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeTypeAndValuesSetOf;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ModifyRequest;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ModifyRequestSeqOf;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ModifyRequestSeqOfSeq;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ModifyRequestSeqOfSeqEnum;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ModifyRequestImpl;
import org.apache.ldap.common.message.spi.ProviderException;

public class ModifyRequestTransform {
    static org.apache.ldap.common.message.ModifyRequest transformFromSnacc(LDAPMessage a_snaccMessage) throws ProviderException {
        ModifyRequestImpl l_request = new ModifyRequestImpl(a_snaccMessage.messageID.intValue());
        ControlTransform.transformFromSnacc((Message)l_request, a_snaccMessage.controls);
        LDAPMessageChoice l_protocolOp = a_snaccMessage.protocolOp;
        ModifyRequest l_snaccRequest = l_protocolOp.modifyRequest;
        l_request.setName(new String(l_snaccRequest.object));
        ModifyRequestSeqOf l_snaccModifications = l_snaccRequest.modification;
        Iterator l_snaccModsList = l_snaccModifications.iterator();
        while (l_snaccModsList.hasNext()) {
            ModifyRequestSeqOfSeq l_snaccMod = (ModifyRequestSeqOfSeq)l_snaccModsList.next();
            AttributeTypeAndValues l_snaccAttr = l_snaccMod.modification;
            AttributeTypeAndValuesSetOf l_snaccValues = l_snaccAttr.vals;
            ModifyRequestSeqOfSeqEnum l_snaccModOp = l_snaccMod.operation;
            LockableAttributeImpl l_attr = new LockableAttributeImpl((Lockable)l_request, new String(l_snaccAttr.type));
            Iterator l_attrValues = l_snaccValues.values().iterator();
            while (l_attrValues.hasNext()) {
                byte[] l_value = (byte[])l_attrValues.next();
                l_attr.add((Object)new String(l_value));
            }
            ModificationItem l_item = null;
            switch (l_snaccModOp.value) {
                case 0: {
                    l_item = new ModificationItem(1, (Attribute)l_attr);
                    break;
                }
                case 1: {
                    l_item = new ModificationItem(3, (Attribute)l_attr);
                    break;
                }
                case 2: {
                    l_item = new ModificationItem(2, (Attribute)l_attr);
                    break;
                }
                default: {
                    throw new ProviderException(SnaccProvider.getProvider(), "Unrecognized snacc modification request operation!");
                }
            }
            l_request.addModification(l_item);
        }
        return l_request;
    }

    static LDAPMessage transformToSnacc(org.apache.ldap.common.message.ModifyRequest a_request) throws ProviderException {
        ModifyRequestSeqOf l_snaccModifications;
        ModifyRequest l_snaccRequest;
        LDAPMessage l_snaccMessage = Utils.prepareEnvelope((Message)a_request);
        LDAPMessageChoice l_protocolOp = l_snaccMessage.protocolOp;
        l_protocolOp.modifyRequest = l_snaccRequest = new ModifyRequest();
        l_protocolOp.choiceId = 0x40000006;
        l_snaccRequest.object = a_request.getName().getBytes();
        l_snaccRequest.modification = l_snaccModifications = new ModifyRequestSeqOf();
        Iterator l_modList = a_request.getModificationItems().iterator();
        while (l_modList.hasNext()) {
            AttributeTypeAndValuesSetOf l_snaccAttrValues;
            ModifyRequestSeqOfSeq l_snaccMod = new ModifyRequestSeqOfSeq();
            AttributeTypeAndValues l_snaccAttr = new AttributeTypeAndValues();
            ModifyRequestSeqOfSeqEnum l_snaccModOp = new ModifyRequestSeqOfSeqEnum();
            l_snaccAttr.vals = l_snaccAttrValues = new AttributeTypeAndValuesSetOf();
            l_snaccMod.modification = l_snaccAttr;
            l_snaccMod.operation = l_snaccModOp;
            ModificationItem l_item = (ModificationItem)l_modList.next();
            switch (l_item.getModificationOp()) {
                case 1: {
                    l_snaccModOp.value = 0;
                    break;
                }
                case 3: {
                    l_snaccModOp.value = 1;
                    break;
                }
                case 2: {
                    l_snaccModOp.value = 2;
                    break;
                }
                default: {
                    throw new ProviderException(SnaccProvider.getProvider(), "Unrecognized modification operation value: " + l_item.getModificationOp());
                }
            }
            Attribute l_attr = l_item.getAttribute();
            l_snaccAttr.type = l_attr.getID().getBytes();
            NamingEnumeration<?> l_valueList = null;
            try {
                l_valueList = l_attr.getAll();
            }
            catch (NamingException ne) {
                ProviderException pe = new ProviderException(SnaccProvider.getProvider(), "Could not acquire enumeration over attribute values!");
                pe.addThrowable((Throwable)ne);
                throw pe;
            }
            while (l_valueList.hasMoreElements()) {
                byte[] l_value = ((String)l_valueList.nextElement()).getBytes();
                l_snaccAttrValues.put(l_value, l_value);
            }
            l_snaccModifications.add(l_snaccMod);
        }
        l_snaccMessage.protocolOp.modifyRequest.modification = l_snaccModifications;
        return l_snaccMessage;
    }
}

