/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.berlib.snacc.ReferralTransform;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPResult;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPResultEnum;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.message.spi.ProviderException;

public class ResultTransform {
    static LdapResult transformFromSnacc(Lockable parent, LDAPResult snaccResult) throws ProviderException {
        byte[] dn;
        LdapResultImpl result = new LdapResultImpl(parent);
        if (snaccResult.errorMessage != null) {
            result.setErrorMessage(new String(snaccResult.errorMessage));
        }
        if (snaccResult.referral != null) {
            ReferralTransform.transformAdd((LdapResult)result, snaccResult.referral);
        }
        if ((dn = snaccResult.matchedDN) == null) {
            result.setMatchedDn("");
        } else {
            result.setMatchedDn(new String(dn));
        }
        LDAPResultEnum snaccCode = snaccResult.resultCode;
        ResultCodeEnum resultCode = ResultCodeEnum.getResultCodeEnum((int)snaccCode.value);
        result.setResultCode(resultCode);
        return result;
    }

    static void transformToSnacc(LDAPResult snaccResult, LdapResult result) throws ProviderException {
        LDAPResultEnum snaccResultEnum;
        snaccResult.resultCode = snaccResultEnum = new LDAPResultEnum();
        snaccResultEnum.value = result.getResultCode().getValue();
        snaccResult.errorMessage = result.getErrorMessage() == null ? "".getBytes() : result.getErrorMessage().getBytes();
        snaccResult.matchedDN = result.getMatchedDn().getBytes();
        snaccResult.referral = ReferralTransform.transform(result.getReferral());
    }
}

