/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.berlib.snacc.ControlTransform;
import org.apache.ldap.common.berlib.snacc.SnaccProvider;
import org.apache.ldap.common.berlib.snacc.Utils;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.berlib.snacc.ldap_v3.PartialAttributeList;
import org.apache.ldap.common.berlib.snacc.ldap_v3.PartialAttributeListSeq;
import org.apache.ldap.common.berlib.snacc.ldap_v3.PartialAttributeListSeqSetOf;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SearchResultEntry;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.SearchResponseEntry;
import org.apache.ldap.common.message.SearchResponseEntryImpl;
import org.apache.ldap.common.message.spi.ProviderException;

public class SearchResponseEntryTransform {
    static SearchResponseEntry transformFromSnacc(LDAPMessage a_snaccMessage) throws ProviderException {
        SearchResponseEntryImpl l_response = new SearchResponseEntryImpl(a_snaccMessage.messageID.intValue());
        LDAPMessageChoice l_snaccOp = a_snaccMessage.protocolOp;
        SearchResultEntry l_snaccResponse = l_snaccOp.searchResEntry;
        ControlTransform.transformFromSnacc((Message)l_response, a_snaccMessage.controls);
        l_response.setObjectName(new String(l_snaccResponse.objectName));
        LockableAttributesImpl l_attributes = new LockableAttributesImpl((Lockable)l_response);
        l_response.setAttributes((Attributes)l_attributes);
        PartialAttributeList l_snaccPal = l_snaccResponse.attributes;
        Iterator l_list = l_snaccPal.iterator();
        while (l_list.hasNext()) {
            PartialAttributeListSeq l_snaccAttr = (PartialAttributeListSeq)l_list.next();
            LockableAttributeImpl l_attr = new LockableAttributeImpl((Lockable)l_attributes, new String(l_snaccAttr.type));
            PartialAttributeListSeqSetOf l_snaccValuesSet = l_snaccAttr.vals;
            Iterator l_snaccValues = l_snaccValuesSet.values().iterator();
            while (l_snaccValues.hasNext()) {
                l_attr.add((Object)new String((byte[])l_snaccValues.next()));
            }
            l_attributes.put((Attribute)l_attr);
        }
        return l_response;
    }

    static LDAPMessage transformToSnacc(SearchResponseEntry a_resp) throws ProviderException {
        PartialAttributeList l_snaccAttributes;
        SearchResultEntry l_snaccResponse;
        LDAPMessage l_snaccMessage = Utils.prepareEnvelope((Message)a_resp);
        LDAPMessageChoice l_snaccOp = l_snaccMessage.protocolOp;
        l_snaccOp.choiceId = 0x40000004;
        l_snaccOp.searchResEntry = l_snaccResponse = new SearchResultEntry();
        l_snaccResponse.objectName = a_resp.getObjectName().getBytes();
        l_snaccResponse.attributes = l_snaccAttributes = new PartialAttributeList();
        NamingEnumeration<? extends Attribute> l_attributeList = a_resp.getAttributes().getAll();
        while (l_attributeList.hasMoreElements()) {
            Attribute l_attr = (Attribute)l_attributeList.nextElement();
            PartialAttributeListSeq l_snaccAttr = new PartialAttributeListSeq();
            PartialAttributeListSeqSetOf l_snaccValues = new PartialAttributeListSeqSetOf();
            l_snaccAttr.type = l_attr.getID().getBytes();
            l_snaccAttr.vals = l_snaccValues;
            for (int ii = 0; ii < l_attr.size(); ++ii) {
                byte[] l_value = null;
                try {
                    l_value = ((String)l_attr.get(ii)).getBytes();
                }
                catch (NamingException ne) {
                    ProviderException pe = new ProviderException(SnaccProvider.getProvider(), "NamingException while extracting attribute value from " + l_attr.getID());
                    pe.addThrowable((Throwable)ne);
                    throw pe;
                }
                l_snaccValues.put(l_value, l_value);
            }
            l_snaccAttributes.add(l_snaccAttr);
        }
        return l_snaccMessage;
    }
}

