/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.BEREncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.EncoderCallback;
import org.apache.asn1.codec.stateful.EncoderMonitor;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderEncoder;
import org.apache.ldap.common.message.spi.ProviderException;

public class SnaccEncoder
implements ProviderEncoder {
    private final Provider provider;

    SnaccEncoder(Provider provider) {
        this.provider = provider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBlocking(Object lock, OutputStream out, Object obj) {
        byte[] buf = this.encodeBlockingByteArray(obj);
        if (lock == null) {
            try {
                out.write(buf);
                out.flush();
            }
            catch (IOException ioe) {
                ProviderException pe = new ProviderException(this.provider, "");
                pe.addThrowable((Throwable)ioe);
                throw pe;
            }
            return;
        }
        Object object = lock;
        synchronized (object) {
            try {
                out.write(buf);
                out.flush();
            }
            catch (IOException ioe) {
                ProviderException pe = new ProviderException(this.provider, "");
                pe.addThrowable((Throwable)ioe);
                throw pe;
            }
            lock.notifyAll();
        }
    }

    public byte[] encodeBlockingByteArray(Object obj) throws ProviderException {
        byte[] buf = null;
        BEREncoder encoder = null;
        LDAPMessage message = null;
        try {
            message = (LDAPMessage)obj;
        }
        catch (ClassCastException cce) {
            ProviderException pe = new ProviderException(this.provider, "Supplied message envelope object not recognized as a Snacc4J LDAPv3 envelope stub!");
            pe.addThrowable((Throwable)cce);
            throw pe;
        }
        encoder = new BEREncoder();
        try {
            message.encode((ASN1Encoder)encoder);
            buf = encoder.toByteArray();
        }
        catch (ASN1Exception e) {
            ProviderException pe = new ProviderException(this.provider, "Snacc4J BEREncoder failed to encode message!");
            pe.addThrowable((Throwable)e);
            throw pe;
        }
        return buf;
    }

    public ByteBuffer encodeBlocking(Object obj) throws ProviderException {
        return ByteBuffer.wrap(this.encodeBlockingByteArray(obj));
    }

    public void encode(Object obj) throws EncoderException {
        throw new UnsupportedOperationException("this encoder is not stateful");
    }

    public void setCallback(EncoderCallback cb) {
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
    }
}

