/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc;

import org.apache.ldap.common.berlib.snacc.AbandonRequestTransform;
import org.apache.ldap.common.berlib.snacc.AddRequestTransform;
import org.apache.ldap.common.berlib.snacc.AddResponseTransform;
import org.apache.ldap.common.berlib.snacc.BindRequestTransform;
import org.apache.ldap.common.berlib.snacc.BindResponseTransform;
import org.apache.ldap.common.berlib.snacc.CompareRequestTransform;
import org.apache.ldap.common.berlib.snacc.CompareResponseTransform;
import org.apache.ldap.common.berlib.snacc.DelRequestTransform;
import org.apache.ldap.common.berlib.snacc.DelResponseTransform;
import org.apache.ldap.common.berlib.snacc.ExtendedRequestTransform;
import org.apache.ldap.common.berlib.snacc.ExtendedResponseTransform;
import org.apache.ldap.common.berlib.snacc.ModifyDnRequestTransform;
import org.apache.ldap.common.berlib.snacc.ModifyDnResponseTransform;
import org.apache.ldap.common.berlib.snacc.ModifyRequestTransform;
import org.apache.ldap.common.berlib.snacc.ModifyResponseTransform;
import org.apache.ldap.common.berlib.snacc.SearchRequestTransform;
import org.apache.ldap.common.berlib.snacc.SearchResponseDoneTransform;
import org.apache.ldap.common.berlib.snacc.SearchResponseEntryTransform;
import org.apache.ldap.common.berlib.snacc.SearchResponseReferenceTransform;
import org.apache.ldap.common.berlib.snacc.UnbindRequestTransform;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessage;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPMessageChoice;
import org.apache.ldap.common.message.AbandonRequest;
import org.apache.ldap.common.message.AddRequest;
import org.apache.ldap.common.message.AddResponse;
import org.apache.ldap.common.message.BindRequest;
import org.apache.ldap.common.message.BindResponse;
import org.apache.ldap.common.message.CompareRequest;
import org.apache.ldap.common.message.CompareResponse;
import org.apache.ldap.common.message.DeleteRequest;
import org.apache.ldap.common.message.DeleteResponse;
import org.apache.ldap.common.message.ExtendedRequest;
import org.apache.ldap.common.message.ExtendedResponse;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.ModifyDnRequest;
import org.apache.ldap.common.message.ModifyDnResponse;
import org.apache.ldap.common.message.ModifyRequest;
import org.apache.ldap.common.message.ModifyResponse;
import org.apache.ldap.common.message.SearchRequest;
import org.apache.ldap.common.message.SearchResponseDone;
import org.apache.ldap.common.message.SearchResponseEntry;
import org.apache.ldap.common.message.SearchResponseReference;
import org.apache.ldap.common.message.UnbindRequest;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderException;
import org.apache.ldap.common.message.spi.TransformerSpi;

public class SnaccTransformer
implements TransformerSpi {
    private final Provider m_provider;

    SnaccTransformer(Provider a_provider) {
        this.m_provider = a_provider;
    }

    public Provider getProvider() {
        return this.m_provider;
    }

    public Object transform(Message a_msg) throws ProviderException {
        LDAPMessage l_snaccMsg = null;
        switch (a_msg.getType().getValue()) {
            case 0x40000010: {
                l_snaccMsg = AbandonRequestTransform.transformToSnacc((AbandonRequest)a_msg);
                break;
            }
            case 0x40000008: {
                l_snaccMsg = AddRequestTransform.transformToSnacc((AddRequest)a_msg);
                break;
            }
            case 0x40000009: {
                l_snaccMsg = AddResponseTransform.transformToSnacc((AddResponse)a_msg);
                break;
            }
            case 0x40000000: {
                l_snaccMsg = BindRequestTransform.transform((BindRequest)a_msg);
                break;
            }
            case 0x40000001: {
                l_snaccMsg = BindResponseTransform.transform((BindResponse)a_msg);
                break;
            }
            case 0x4000000E: {
                l_snaccMsg = CompareRequestTransform.transformToSnacc((CompareRequest)a_msg);
                break;
            }
            case 0x4000000F: {
                l_snaccMsg = CompareResponseTransform.transformToSnacc((CompareResponse)a_msg);
                break;
            }
            case 0x4000000A: {
                l_snaccMsg = DelRequestTransform.transformToSnacc((DeleteRequest)a_msg);
                break;
            }
            case 0x4000000B: {
                l_snaccMsg = DelResponseTransform.transformToSnacc((DeleteResponse)a_msg);
                break;
            }
            case 1073741847: {
                l_snaccMsg = ExtendedRequestTransform.transformToSnacc((ExtendedRequest)a_msg);
                break;
            }
            case 1073741848: {
                l_snaccMsg = ExtendedResponseTransform.transformToSnacc((ExtendedResponse)a_msg);
                break;
            }
            case 0x4000000C: {
                l_snaccMsg = ModifyDnRequestTransform.transformToSnacc((ModifyDnRequest)a_msg);
                break;
            }
            case 0x4000000D: {
                l_snaccMsg = ModifyDnResponseTransform.transformToSnacc((ModifyDnResponse)a_msg);
                break;
            }
            case 0x40000006: {
                l_snaccMsg = ModifyRequestTransform.transformToSnacc((ModifyRequest)a_msg);
                break;
            }
            case 0x40000007: {
                l_snaccMsg = ModifyResponseTransform.transformToSnacc((ModifyResponse)a_msg);
                break;
            }
            case 0x40000003: {
                l_snaccMsg = SearchRequestTransform.transformToSnacc((SearchRequest)a_msg);
                break;
            }
            case 0x40000005: {
                l_snaccMsg = SearchResponseDoneTransform.transformToSnacc((SearchResponseDone)a_msg);
                break;
            }
            case 0x40000004: {
                l_snaccMsg = SearchResponseEntryTransform.transformToSnacc((SearchResponseEntry)a_msg);
                break;
            }
            case 1073741843: {
                l_snaccMsg = SearchResponseReferenceTransform.transformToSnacc((SearchResponseReference)a_msg);
                break;
            }
            case 0x40000002: {
                l_snaccMsg = UnbindRequestTransform.transformToSnacc((UnbindRequest)a_msg);
                break;
            }
            default: {
                throw new ProviderException(this.m_provider, "Unknown message type: " + a_msg.getType().getName());
            }
        }
        return l_snaccMsg;
    }

    public Message transform(Object a_obj) throws ProviderException {
        AbandonRequest l_message = null;
        LDAPMessage l_snaccMsg = null;
        LDAPMessageChoice l_op = null;
        try {
            l_snaccMsg = (LDAPMessage)a_obj;
        }
        catch (ClassCastException e) {
            ProviderException pe = new ProviderException(this.m_provider, "Object to be transformed was not recognized as a Snacc4J generated stub base LDAPMessage envelope!");
            pe.addThrowable((Throwable)e);
            throw pe;
        }
        l_op = l_snaccMsg.protocolOp;
        switch (l_op.choiceId) {
            case 0x40000010: {
                l_message = AbandonRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000008: {
                l_message = AddRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000009: {
                l_message = AddResponseTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000000: {
                l_message = BindRequestTransform.transform(l_snaccMsg);
                break;
            }
            case 0x40000001: {
                l_message = BindResponseTransform.transform(l_snaccMsg);
                break;
            }
            case 0x4000000E: {
                l_message = CompareRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x4000000F: {
                l_message = CompareResponseTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x4000000A: {
                l_message = DelRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x4000000B: {
                l_message = DelResponseTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 1073741847: {
                l_message = ExtendedRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 1073741848: {
                l_message = ExtendedResponseTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x4000000C: {
                l_message = ModifyDnRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x4000000D: {
                l_message = ModifyDnResponseTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000006: {
                l_message = ModifyRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000007: {
                l_message = ModifyResponseTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000003: {
                l_message = SearchRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000005: {
                l_message = SearchResponseDoneTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000004: {
                l_message = SearchResponseEntryTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 1073741843: {
                l_message = SearchResponseReferenceTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            case 0x40000002: {
                l_message = UnbindRequestTransform.transformFromSnacc(l_snaccMsg);
                break;
            }
            default: {
                throw new ProviderException(this.m_provider, "Unrecognized message choice id value: " + l_op.choiceId);
            }
        }
        return l_message;
    }
}

