/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeList;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class AddRequest
implements LDAP_V3 {
    public byte[] entry;
    public AttributeList attributes = new AttributeList();

    public AddRequest() {
    }

    public AddRequest(AddRequest arg) {
        this.entry = new byte[arg.entry.length];
        System.arraycopy(arg.entry, 0, this.entry, 0, arg.entry.length);
        this.attributes = new AttributeList(arg.attributes);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)8));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.entry);
        this.attributes.encode(enc);
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)8));
        int seq_nr = dec.decodeSequence();
        this.entry = dec.decodeOctetString();
        this.attributes.decode(dec);
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("entry = ");
        os.print(Hex.toString((byte[])this.entry));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributes = ");
        this.attributes.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

