/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SaslCredentials;

public class AuthenticationChoice
implements LDAP_V3 {
    public static final int SIMPLE_CID = Integer.MIN_VALUE;
    public static final int SASL_CID = -2147483645;
    int[] tag_list = new int[]{Integer.MIN_VALUE, -2147483645};
    public int choiceId;
    public byte[] simple = null;
    public SaslCredentials sasl = null;

    public AuthenticationChoice() {
    }

    public AuthenticationChoice(AuthenticationChoice arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case -2147483648: {
                this.simple = new byte[arg.simple.length];
                System.arraycopy(arg.simple, 0, this.simple, 0, arg.simple.length);
                break;
            }
            case -2147483645: {
                this.sasl = new SaslCredentials(arg.sasl);
            }
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case -2147483648: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)0));
                enc.encodeOctetString(this.simple);
                break;
            }
            case -2147483645: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)3));
                this.sasl.encode(enc);
            }
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.choiceId = dec.decodeChoice(this.tag_list);
        switch (this.choiceId) {
            case -2147483648: {
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)0));
                this.simple = dec.decodeOctetString();
                break;
            }
            case -2147483645: {
                this.sasl = new SaslCredentials();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)3));
                this.sasl.decode(dec);
            }
        }
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case -2147483648: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("simple = ");
                os.print(Hex.toString((byte[])this.simple));
                break;
            }
            case -2147483645: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("sasl = ");
                this.sasl.print(os, indent + 2);
            }
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

