/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAPResultEnum;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;
import org.apache.ldap.common.berlib.snacc.ldap_v3.Referral;

public class ExtendedResponse
implements LDAP_V3 {
    public LDAPResultEnum resultCode = new LDAPResultEnum();
    public byte[] matchedDN;
    public byte[] errorMessage;
    public Referral referral = null;
    public byte[] responseName = null;
    public byte[] response = null;

    public ExtendedResponse() {
    }

    public ExtendedResponse(ExtendedResponse arg) {
        this.resultCode = new LDAPResultEnum(arg.resultCode);
        this.matchedDN = new byte[arg.matchedDN.length];
        System.arraycopy(arg.matchedDN, 0, this.matchedDN, 0, arg.matchedDN.length);
        this.errorMessage = new byte[arg.errorMessage.length];
        System.arraycopy(arg.errorMessage, 0, this.errorMessage, 0, arg.errorMessage.length);
        if (arg.referral != null) {
            this.referral = new Referral(arg.referral);
        }
        if (arg.responseName != null) {
            this.responseName = new byte[arg.responseName.length];
            System.arraycopy(arg.responseName, 0, this.responseName, 0, arg.responseName.length);
        }
        if (arg.response != null) {
            this.response = new byte[arg.response.length];
            System.arraycopy(arg.response, 0, this.response, 0, arg.response.length);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)24));
        int seq_nr = enc.encodeSequence();
        this.resultCode.encode(enc);
        enc.encodeOctetString(this.matchedDN);
        enc.encodeOctetString(this.errorMessage);
        if (this.referral != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)3));
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)3));
            this.referral.encode(enc);
        }
        if (this.responseName != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)10));
            enc.encodeOctetString(this.responseName);
        }
        if (this.response != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)11));
            enc.encodeOctetString(this.response);
        }
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)24));
        int seq_nr = dec.decodeSequence();
        this.resultCode.decode(dec);
        this.matchedDN = dec.decodeOctetString();
        this.errorMessage = dec.decodeOctetString();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)3))) {
            this.referral = new Referral();
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)3));
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)3));
            this.referral.decode(dec);
        }
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)10))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)10));
            this.responseName = dec.decodeOctetString();
        }
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)11))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)11));
            this.response = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("resultCode = ");
        this.resultCode.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("matchedDN = ");
        os.print(Hex.toString((byte[])this.matchedDN));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errorMessage = ");
        os.print(Hex.toString((byte[])this.errorMessage));
        os.println(',');
        if (this.referral != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("referral = ");
            this.referral.print(os, indent + 2);
            os.println(',');
        }
        if (this.responseName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("responseName = ");
            os.print(Hex.toString((byte[])this.responseName));
            os.println(',');
        }
        if (this.response != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("response = ");
            os.print(Hex.toString((byte[])this.response));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

