/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.AttributeValueAssertion;
import org.apache.ldap.common.berlib.snacc.ldap_v3.FilterSetOf;
import org.apache.ldap.common.berlib.snacc.ldap_v3.FilterSetOf1;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;
import org.apache.ldap.common.berlib.snacc.ldap_v3.MatchingRuleAssertion;
import org.apache.ldap.common.berlib.snacc.ldap_v3.SubstringFilter;

public class Filter
implements LDAP_V3 {
    public static final int AND_CID = Integer.MIN_VALUE;
    public static final int OR_CID = -2147483647;
    public static final int NOT_CID = -2147483646;
    public static final int EQUALITYMATCH_CID = -2147483645;
    public static final int SUBSTRINGS_CID = -2147483644;
    public static final int GREATEROREQUAL_CID = -2147483643;
    public static final int LESSOREQUAL_CID = -2147483642;
    public static final int PRESENT_CID = -2147483641;
    public static final int APPROXMATCH_CID = -2147483640;
    public static final int EXTENSIBLEMATCH_CID = -2147483639;
    int[] tag_list = new int[]{Integer.MIN_VALUE, -2147483647, -2147483646, -2147483645, -2147483644, -2147483643, -2147483642, -2147483641, -2147483640, -2147483639};
    public int choiceId;
    public FilterSetOf and = null;
    public FilterSetOf1 or = null;
    public Filter not = null;
    public AttributeValueAssertion equalityMatch = null;
    public SubstringFilter substrings = null;
    public AttributeValueAssertion greaterOrEqual = null;
    public AttributeValueAssertion lessOrEqual = null;
    public byte[] present = null;
    public AttributeValueAssertion approxMatch = null;
    public MatchingRuleAssertion extensibleMatch = null;

    public Filter() {
    }

    public Filter(Filter arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case -2147483648: {
                this.and = new FilterSetOf(arg.and);
                break;
            }
            case -2147483647: {
                this.or = new FilterSetOf1(arg.or);
                break;
            }
            case -2147483646: {
                this.not = new Filter(arg.not);
                break;
            }
            case -2147483645: {
                this.equalityMatch = new AttributeValueAssertion(arg.equalityMatch);
                break;
            }
            case -2147483644: {
                this.substrings = new SubstringFilter(arg.substrings);
                break;
            }
            case -2147483643: {
                this.greaterOrEqual = new AttributeValueAssertion(arg.greaterOrEqual);
                break;
            }
            case -2147483642: {
                this.lessOrEqual = new AttributeValueAssertion(arg.lessOrEqual);
                break;
            }
            case -2147483641: {
                this.present = new byte[arg.present.length];
                System.arraycopy(arg.present, 0, this.present, 0, arg.present.length);
                break;
            }
            case -2147483640: {
                this.approxMatch = new AttributeValueAssertion(arg.approxMatch);
                break;
            }
            case -2147483639: {
                this.extensibleMatch = new MatchingRuleAssertion(arg.extensibleMatch);
            }
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case -2147483648: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)0));
                this.and.encode(enc);
                break;
            }
            case -2147483647: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)1));
                this.or.encode(enc);
                break;
            }
            case -2147483646: {
                int ex_id_not1 = enc.encodeExplicit(ASN1Encoder.makeTag((int)2, (int)2));
                this.not.encode(enc);
                enc.endOf(ex_id_not1);
                break;
            }
            case -2147483645: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)3));
                this.equalityMatch.encode(enc);
                break;
            }
            case -2147483644: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)4));
                this.substrings.encode(enc);
                break;
            }
            case -2147483643: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)5));
                this.greaterOrEqual.encode(enc);
                break;
            }
            case -2147483642: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)6));
                this.lessOrEqual.encode(enc);
                break;
            }
            case -2147483641: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)7));
                enc.encodeOctetString(this.present);
                break;
            }
            case -2147483640: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)8));
                this.approxMatch.encode(enc);
                break;
            }
            case -2147483639: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)9));
                this.extensibleMatch.encode(enc);
            }
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.choiceId = dec.decodeChoice(this.tag_list);
        switch (this.choiceId) {
            case -2147483648: {
                this.and = new FilterSetOf();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)0));
                this.and.decode(dec);
                break;
            }
            case -2147483647: {
                this.or = new FilterSetOf1();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)1));
                this.or.decode(dec);
                break;
            }
            case -2147483646: {
                this.not = new Filter();
                int ex_id_not1 = dec.decodeExplicit(ASN1Decoder.makeTag((int)2, (int)2));
                this.not.decode(dec);
                dec.endOf(ex_id_not1);
                break;
            }
            case -2147483645: {
                this.equalityMatch = new AttributeValueAssertion();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)3));
                this.equalityMatch.decode(dec);
                break;
            }
            case -2147483644: {
                this.substrings = new SubstringFilter();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)4));
                this.substrings.decode(dec);
                break;
            }
            case -2147483643: {
                this.greaterOrEqual = new AttributeValueAssertion();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)5));
                this.greaterOrEqual.decode(dec);
                break;
            }
            case -2147483642: {
                this.lessOrEqual = new AttributeValueAssertion();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)6));
                this.lessOrEqual.decode(dec);
                break;
            }
            case -2147483641: {
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)7));
                this.present = dec.decodeOctetString();
                break;
            }
            case -2147483640: {
                this.approxMatch = new AttributeValueAssertion();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)8));
                this.approxMatch.decode(dec);
                break;
            }
            case -2147483639: {
                this.extensibleMatch = new MatchingRuleAssertion();
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)9));
                this.extensibleMatch.decode(dec);
            }
        }
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case -2147483648: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("and = ");
                this.and.print(os, indent + 2);
                break;
            }
            case -2147483647: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("or = ");
                this.or.print(os, indent + 2);
                break;
            }
            case -2147483646: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("not = ");
                this.not.print(os, indent + 2);
                break;
            }
            case -2147483645: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("equalityMatch = ");
                this.equalityMatch.print(os, indent + 2);
                break;
            }
            case -2147483644: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("substrings = ");
                this.substrings.print(os, indent + 2);
                break;
            }
            case -2147483643: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("greaterOrEqual = ");
                this.greaterOrEqual.print(os, indent + 2);
                break;
            }
            case -2147483642: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("lessOrEqual = ");
                this.lessOrEqual.print(os, indent + 2);
                break;
            }
            case -2147483641: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("present = ");
                os.print(Hex.toString((byte[])this.present));
                break;
            }
            case -2147483640: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("approxMatch = ");
                this.approxMatch.print(os, indent + 2);
                break;
            }
            case -2147483639: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("extensibleMatch = ");
                this.extensibleMatch.print(os, indent + 2);
            }
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

