/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class MatchingRuleAssertion
implements LDAP_V3 {
    public byte[] matchingRule = null;
    public byte[] type = null;
    public byte[] matchValue;
    public boolean dnAttributes = false;

    public MatchingRuleAssertion() {
    }

    public MatchingRuleAssertion(MatchingRuleAssertion arg) {
        if (arg.matchingRule != null) {
            this.matchingRule = new byte[arg.matchingRule.length];
            System.arraycopy(arg.matchingRule, 0, this.matchingRule, 0, arg.matchingRule.length);
        }
        if (arg.type != null) {
            this.type = new byte[arg.type.length];
            System.arraycopy(arg.type, 0, this.type, 0, arg.type.length);
        }
        this.matchValue = new byte[arg.matchValue.length];
        System.arraycopy(arg.matchValue, 0, this.matchValue, 0, arg.matchValue.length);
        this.dnAttributes = arg.dnAttributes;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        if (this.matchingRule != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)1));
            enc.encodeOctetString(this.matchingRule);
        }
        if (this.type != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)2));
            enc.encodeOctetString(this.type);
        }
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)3));
        enc.encodeOctetString(this.matchValue);
        if (enc.encodeDefault() || this.dnAttributes) {
            enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)4));
            enc.encodeBoolean(this.dnAttributes);
        }
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)1))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)1));
            this.matchingRule = dec.decodeOctetString();
        }
        if (!dec.nextIsOptional(ASN1Decoder.makeTag((int)2, (int)2))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)2));
            this.type = dec.decodeOctetString();
        }
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)3));
        this.matchValue = dec.decodeOctetString();
        if (!dec.nextIsDefault(ASN1Decoder.makeTag((int)2, (int)4))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)4));
            this.dnAttributes = dec.decodeBoolean();
        }
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        if (this.matchingRule != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("matchingRule = ");
            os.print(Hex.toString((byte[])this.matchingRule));
            os.println(',');
        }
        if (this.type != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("type = ");
            os.print(Hex.toString((byte[])this.type));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("matchValue = ");
        os.print(Hex.toString((byte[])this.matchValue));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("dnAttributes = ");
        os.print(this.dnAttributes);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

