/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;
import org.apache.ldap.common.berlib.snacc.ldap_v3.ModifyRequestSeqOf;

public class ModifyRequest
implements LDAP_V3 {
    public byte[] object;
    public ModifyRequestSeqOf modification = new ModifyRequestSeqOf();

    public ModifyRequest() {
    }

    public ModifyRequest(ModifyRequest arg) {
        this.object = new byte[arg.object.length];
        System.arraycopy(arg.object, 0, this.object, 0, arg.object.length);
        this.modification = new ModifyRequestSeqOf(arg.modification);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)6));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.object);
        this.modification.encode(enc);
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)6));
        int seq_nr = dec.decodeSequence();
        this.object = dec.decodeOctetString();
        this.modification.decode(dec);
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("object = ");
        os.print(Hex.toString((byte[])this.object));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("modification = ");
        this.modification.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

