/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;
import org.apache.ldap.common.berlib.snacc.ldap_v3.PartialAttributeList;

public class SearchResultEntry
implements LDAP_V3 {
    public byte[] objectName;
    public PartialAttributeList attributes = new PartialAttributeList();

    public SearchResultEntry() {
    }

    public SearchResultEntry(SearchResultEntry arg) {
        this.objectName = new byte[arg.objectName.length];
        System.arraycopy(arg.objectName, 0, this.objectName, 0, arg.objectName.length);
        this.attributes = new PartialAttributeList(arg.attributes);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag((int)1, (int)4));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.objectName);
        this.attributes.encode(enc);
        enc.endOf(seq_nr);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag((int)1, (int)4));
        int seq_nr = dec.decodeSequence();
        this.objectName = dec.decodeOctetString();
        this.attributes.decode(dec);
        dec.endOf(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("objectName = ");
        os.print(Hex.toString((byte[])this.objectName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attributes = ");
        this.attributes.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

