/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.snacc.ldap_v3;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.ldap.common.berlib.snacc.ldap_v3.LDAP_V3;

public class SubstringFilterSeqOfChoice
implements LDAP_V3 {
    public static final int INITIAL_CID = Integer.MIN_VALUE;
    public static final int ANY_CID = -2147483647;
    public static final int FINAL1_CID = -2147483646;
    int[] tag_list = new int[]{Integer.MIN_VALUE, -2147483647, -2147483646};
    public int choiceId;
    public byte[] initial = null;
    public byte[] any = null;
    public byte[] final1 = null;

    public SubstringFilterSeqOfChoice() {
    }

    public SubstringFilterSeqOfChoice(SubstringFilterSeqOfChoice arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case -2147483648: {
                this.initial = new byte[arg.initial.length];
                System.arraycopy(arg.initial, 0, this.initial, 0, arg.initial.length);
                break;
            }
            case -2147483647: {
                this.any = new byte[arg.any.length];
                System.arraycopy(arg.any, 0, this.any, 0, arg.any.length);
                break;
            }
            case -2147483646: {
                this.final1 = new byte[arg.final1.length];
                System.arraycopy(arg.final1, 0, this.final1, 0, arg.final1.length);
            }
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case -2147483648: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)0));
                enc.encodeOctetString(this.initial);
                break;
            }
            case -2147483647: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)1));
                enc.encodeOctetString(this.any);
                break;
            }
            case -2147483646: {
                enc.nextIsImplicit(ASN1Encoder.makeTag((int)2, (int)2));
                enc.encodeOctetString(this.final1);
            }
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.choiceId = dec.decodeChoice(this.tag_list);
        switch (this.choiceId) {
            case -2147483648: {
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)0));
                this.initial = dec.decodeOctetString();
                break;
            }
            case -2147483647: {
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)1));
                this.any = dec.decodeOctetString();
                break;
            }
            case -2147483646: {
                dec.nextIsImplicit(ASN1Decoder.makeTag((int)2, (int)2));
                this.final1 = dec.decodeOctetString();
            }
        }
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case -2147483648: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("initial = ");
                os.print(Hex.toString((byte[])this.initial));
                break;
            }
            case -2147483647: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("any = ");
                os.print(Hex.toString((byte[])this.any));
                break;
            }
            case -2147483646: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("final = ");
                os.print(Hex.toString((byte[])this.final1));
            }
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

