/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.doxia.module.rtf;

import org.codehaus.doxia.module.rtf.FontMetrics;

public class Font {
    private int style;
    private int size;
    private FontMetrics metrics;

    public Font(int style, int size) throws Exception {
        this.style = style;
        this.size = size;
        this.metrics = FontMetrics.find(style);
    }

    public int ascent() {
        return this.toTwips(this.metrics.ascent);
    }

    public int descent() {
        return this.toTwips(this.metrics.descent);
    }

    public TextExtents textExtents(String text) {
        int width = 0;
        short ascent = 0;
        short descent = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            int c = text.charAt(i);
            if (c > 255) {
                c = 32;
            }
            FontMetrics.CharMetrics metrics = this.metrics.charMetrics[c];
            width += metrics.wx;
            if (metrics.ury > ascent) {
                ascent = metrics.ury;
            }
            if (metrics.lly >= descent) continue;
            descent = metrics.lly;
        }
        int height = ascent + Math.abs(descent);
        return new TextExtents(this.toTwips(width), this.toTwips(height), this.toTwips(ascent));
    }

    private int toTwips(int length) {
        return (int)Math.rint((double)length * (double)this.size / 50.0);
    }

    static class TextExtents {
        int width;
        int height;
        int ascent;

        TextExtents(int width, int height, int ascent) {
            this.width = width;
            this.height = height;
            this.ascent = ascent;
        }
    }
}

