/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLine;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatusLineManager
extends ContributionManager
implements IStatusLineManager {
    private StatusLine statusLine = null;

    public StatusLine createControl(Composite parent) {
        if (!this.statusLineExist() && parent != null) {
            this.statusLine = new StatusLine(parent);
            this.update(false);
        }
        return this.statusLine;
    }

    public void dispose() {
        if (this.statusLineExist()) {
            this.statusLine.dispose();
        }
        this.statusLine = null;
        IContributionItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public Control getControl() {
        return this.statusLine;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.statusLine;
    }

    public boolean isCancelEnabled() {
        return this.statusLineExist() && this.statusLine.isCancelEnabled();
    }

    public void setCancelEnabled(boolean enabled) {
        if (this.statusLineExist()) {
            this.statusLine.setCancelEnabled(enabled);
        }
    }

    public void setErrorMessage(String message) {
        if (this.statusLineExist()) {
            this.statusLine.setErrorMessage(message);
        }
    }

    public void setErrorMessage(Image image, String message) {
        if (this.statusLineExist()) {
            this.statusLine.setErrorMessage(image, message);
        }
    }

    public void setMessage(String message) {
        if (this.statusLineExist()) {
            this.statusLine.setMessage(message);
        }
    }

    public void setMessage(Image image, String message) {
        if (this.statusLineExist()) {
            this.statusLine.setMessage(image, message);
        }
    }

    private boolean statusLineExist() {
        return this.statusLine != null && !this.statusLine.isDisposed();
    }

    public void update(boolean force) {
        if ((this.isDirty() || force) && this.statusLineExist()) {
            this.statusLine.setRedraw(false);
            IContributionItem[] items = this.getItems();
            HashMap<IContributionItem, IContributionItem> ht = new HashMap<IContributionItem, IContributionItem>(items.length * 2);
            int i = 0;
            while (i < items.length) {
                IContributionItem ci = items[i];
                if (ci.isVisible()) {
                    ht.put(ci, ci);
                }
                ++i;
            }
            Control[] ws = this.statusLine.getChildren();
            int i2 = 0;
            while (i2 < ws.length) {
                IContributionItem item;
                Object data = ws[i2].getData();
                if (data instanceof IContributionItem && ht.get(item = (IContributionItem)data) == null) {
                    ws[i2].dispose();
                }
                ++i2;
            }
            ws = this.statusLine.getChildren();
            int srcIx = 3;
            int destIx = 0;
            int oldChildCount = ws.length;
            int i3 = 0;
            while (i3 < items.length) {
                IContributionItem src = items[i3];
                if (src.isVisible()) {
                    IContributionItem dest = srcIx < ws.length ? (IContributionItem)ws[srcIx].getData() : null;
                    if (dest != null && src.equals(dest)) {
                        ++srcIx;
                    } else {
                        src.fill(this.statusLine);
                        Control[] newChildren = this.statusLine.getChildren();
                        int j = oldChildCount;
                        while (j < newChildren.length) {
                            newChildren[j].setData((Object)src);
                            ++j;
                        }
                        oldChildCount = newChildren.length;
                    }
                    ++destIx;
                }
                ++i3;
            }
            this.setDirty(false);
            this.statusLine.layout();
            this.statusLine.setRedraw(true);
        }
    }
}

